package edu.uulm.scbayes.inference

import edu.uulm.scbayes.factorgraph.DiscreteFactorGraph
import util.Random
import edu.uulm.scbayes.probabilities.{DiscreteMarginals, DiscreteVariable}

/**
 * Capsules inference algorithms on factor graphs that work by iteratively improving the result.
 *
 * This encompasses MCMC and Loopy Belief Propagation.
 *
 *
 * Date: 26.05.11
 */
abstract class InferenceAlgorithm[V <: DiscreteVariable](val graph: DiscreteFactorGraph[V,_],
                                                         val query: Set[V]) {
  //the state representation
  type Repr

  def createInitialState(random: Random): Repr
  def computeStep(oldState: Repr, random: Random): Repr
  def computeMarginals(variable: V, value: Int, state: Repr): Double
  def canInfer(variable: V): Boolean = query.contains(variable)

  def marginalInferer(state: Repr) = new DiscreteMarginals[V] {
    def marginal(rv: V, value: Int): Double = computeMarginals(rv,value,state)
    def canInfer(v: V): Boolean = canInfer(v)
  }
}