package edu.uulm.scbayes.inference

import util.Random
import edu.uulm.scbayes.probabilities.{DiscreteMarginals, DiscreteVariable}
import edu.uulm.scbayes.factorgraph.{DiscreteFactor, DiscreteFactorGraph}

trait NInferer {
  def infer[V <: DiscreteVariable, F <: DiscreteFactor[V]](graph: DiscreteFactorGraph[V,F]): DiscreteMarginals[V]
}

trait SteppingInferer {
  type TState[V <: DiscreteVariable, F <: DiscreteFactor[V]]
  def advanceState[V <: DiscreteVariable, F <: DiscreteFactor[V]](state: this.TState[V,F]): this.TState[V,F]
  def marginals[V <: DiscreteVariable, F <: DiscreteFactor[V]](state: this.TState[V,F]): DiscreteMarginals[V]
}

trait SteppingGraphInferer extends SteppingInferer {
  def createInitialState[V <: DiscreteVariable, F <: DiscreteFactor[V]](graph: DiscreteFactorGraph[V,F],
                                                                        query: Set[V],
                                                                        random: Random): this.TState[V,F]

  final def createIterator[V <: DiscreteVariable, F <: DiscreteFactor[V]](graph: DiscreteFactorGraph[V,F],
                                                                        query: Set[V],
                                                                        random: Random): Iterator[this.TState[V,F]] =
    Iterator.iterate(createInitialState(graph,query,random))(advanceState)
}