package edu.uulm.scbayes.inference

import edu.uulm.scbayes.probabilities.DiscreteMarginals
import edu.uulm.scbayes.probabilities.DiscreteVariable
import util.Random

/**
 * Implements the basic behaviour of all those marginal inferers that can do one more step
 * to improve their results.
 *
 *
 * Date: 26.05.11
 */

class SteppingInfererDP[V <: DiscreteVariable](val inferer: InferenceAlgorithm[V], private val random: Random = new Random) {

  private var state: inferer.Repr = inferer.createInitialState(random)
  private var steps = 0


  def reset() {
    steps = 0
    state = inferer.createInitialState(random)
  }

  /** This function advances the inference procedure by one step. */
  def step() {
    state = inferer.computeStep(state, random)
    steps = steps + 1
  }

  /** Perform a certain number of steps. */
  def runFor(steps: Int) {for(i <- 1 to steps) {step()}}

  def getMarginals: DiscreteMarginals[V] = new DiscreteMarginals[V] {
    def canInfer(v: V): Boolean = inferer.canInfer(v)

    def marginal(rv: V, value: Int): Double = inferer.computeMarginals(rv,value,state)
  }

  /** Don't mutate this! */
  def getCurrentState = state

  def getSteps: Int = steps
}
