package edu.uulm.scbayes.inference.bp

import edu.uulm.scbayes.factorgraph.{DiscreteFactor, DiscreteFactorGraph}
import util.Random
import edu.uulm.scbayes.probabilities.{DiscreteMarginals, DiscreteVariable}
import edu.uulm.scbayes.factorgraph.messages.DiscreteMessage
import edu.uulm.scbayes.inference.SteppingGraphInferer

/**
 * Implements the flooding protocol for belief propagation.
 *
 *
 * Date: 15.06.11
 */

object FloodingBeliefPropagationStepper extends SteppingGraphInferer {

  def marginals[V <: DiscreteVariable, F <: DiscreteFactor[V]](state: FloodingBeliefPropagationStepper.TState[V,F]): DiscreteMarginals[V] =
    BeliefPropagation.marginals(state._1, state._2)

  def advanceState[V <: DiscreteVariable, F <: DiscreteFactor[V]](state: FloodingBeliefPropagationStepper.TState[V,F]): FloodingBeliefPropagationStepper.TState[V,F] = {
    val graph = state._1
    (graph,
      BeliefPropagation.computeFactorMessages(
      graph,
      BeliefPropagation.computeVariableMessages(graph, state._2, graph.variables),
      graph.factors))
  }

  def createInitialState[V <: DiscreteVariable, F <: DiscreteFactor[V]](graph: DiscreteFactorGraph[V, F],
                                                                        query: Set[V],
                                                                        random: Random): FloodingBeliefPropagationStepper.TState[V,F] = {
    (graph,
      BeliefPropagation.computeFactorMessages(
        graph,
        BeliefPropagation.createInitialVariableMessages(graph, BeliefPropagation.randomMessageGenerator(random)),
        graph.factors))
  }

  type TState[V <: DiscreteVariable, F <: DiscreteFactor[V]] = (DiscreteFactorGraph[V,F],Map[(F,V),DiscreteMessage])
}
