package edu.uulm.scbayes.inference.incremental

import edu.uulm.scbayes.mln._
import edu.uulm.scbayes.logic._
import edu.uulm.scbayes.probabilities.DiscreteMarginals
import factorgraph.LogicNode
import util.Random

/**
 * Specifies the problem of doing inference over an incrementally changing MLN.
 *
 *
 * Date: 17.06.11
 */

trait IncrementalMLNInferer {
  type TIncRes

  def createInitialResult(mln: MarkovLogicNetwork,
                          evidence: TruthAssignment,
                          random: Random): TIncRes

  def createIncrementalResult(oldState: TIncRes,
                newConstants: Set[Constant],
                newEvidence: TruthAssignment): TIncRes

  /** @return the marginals for the complete MLN */
  def marginals[V](state: TIncRes): DiscreteMarginals[LogicNode]
}




