package edu.uulm.scbayes.logic

sealed abstract class GroundPredicate(p: AbstractPredicateDefinition, override val parameters: Seq[Constant])
  extends Predicate(p,parameters) {
  //assert(p.parameters == parameters.map(_.sort))
}

object GroundPredicate {
  def apply(pd: AtomDefinition, pars: Seq[Constant]): GroundPredicate = {
    pd match {
      case fpd: FunctionalPredicateDefinition => new FunctionalGroundPredicate(fpd,pars)
      case pd: NormalPredicateDefinition => new GroundNormalPredicate(pd, pars)
      case _ => throw new RuntimeException("unknown predicate definition")
    }
  }
}

class GroundNormalPredicate protected[logic] (override val predicate: NormalPredicateDefinition, _pars: Seq[Constant])
  extends GroundPredicate(predicate,_pars) {

  def arguments: Seq[Constant] = parameters

  def name: PredicateAtomDefinition = predicate.asInstanceOf[PredicateAtomDefinition]
}

object GroundNormalPredicate{
  def apply(pd: NormalPredicateDefinition, pars: Seq[Constant]) = new GroundNormalPredicate(pd, pars)
  def unapply(pred: GroundNormalPredicate) = Some((pred.predicate,pred.parameters))
}

case class GroundFunctionBase(pd: FunctionalPredicateDefinition, arguments: Seq[Constant]) {
  override def toString = "%s(%s)".format(pd.name,arguments.mkString(", "))

  def name: FunctionalAtomDefinition = this.pd
}

class FunctionalGroundPredicate protected[logic] (override val predicate: FunctionalPredicateDefinition, _pars: Seq[Constant])
  extends GroundPredicate(predicate, _pars){
  val arguments = _pars.reverse.tail.reverse
  val result = _pars.last
  val functionBase = GroundFunctionBase(predicate,arguments)

  def target: Constant = this.result
}


