package edu.uulm.scbayes.logic

sealed abstract class AbstractPredicateDefinition(val name: String, val parameters: Seq[Sort])
extends AtomDefinition {

  override def equals(x: Any) = x match {
    case NormalPredicateDefinition(n,p) => n == name && p == parameters
    case _ => false
  }
  override def hashCode = name.hashCode ^ parameters.hashCode
}

class NormalPredicateDefinition(name: String, parameters: Seq[Sort])
  extends AbstractPredicateDefinition(name, parameters)
  with PredicateAtomDefinition {

  override def equals(x: Any) = x match {
    case npd@NormalPredicateDefinition(n,p) => this.eq(npd) || (this.hashCode == npd.hashCode && n == name && p == parameters)
    case _ => false
  }

  val hashCodeMemo = name.hashCode ^ parameters.hashCode

  override def hashCode = hashCodeMemo

  def baseSignature: Seq[Sort] = this.parameters

  override def toString: String = "%s(%s)".format(name,parameters.map(_.name).mkString(","))
}

object NormalPredicateDefinition {
  def apply(n: String, par: List[Sort]) = new NormalPredicateDefinition(n,par)
  def unapply(pd: NormalPredicateDefinition) = Some((pd.name,pd.parameters))
}

class FunctionalPredicateDefinition(name: String, parameters: Seq[Sort])
  extends AbstractPredicateDefinition(name, parameters)
  with FunctionalAtomDefinition{

  val hashCodeMemo = name.hashCode ^ parameters.hashCode
  override def hashCode = hashCodeMemo

  override def signature = this.parameters

  def targetSignature: Sort = result
  val arguments : Seq[Sort]  = parameters.reverse.tail.reverse
  val result: Sort = parameters.last

  override def toString: String = "%s(%s!)".format(name,parameters.map(_.name).mkString(","))

  override def equals(that: Any): Boolean =  that match {
    case fpd: FunctionalPredicateDefinition => this.eq(fpd) ||
      (this.hashCode == that.hashCode &&
      this.name == fpd.name && this.parameters == fpd.parameters)
    case _ => false
  }
}

object FunctionalPredicateDefinition {
  def apply(n: String, par: List[Sort]) = new FunctionalPredicateDefinition(n,par)
  def unapply(pd: FunctionalPredicateDefinition) = Some((pd.name,pd.parameters))
}