package edu.uulm.scbayes.logic

class TemporalSignature(val signature: Signature) {
  /** true if all predicates are dynamic. */
  def isPureDynamic: Boolean = signature.predicates.forall(_.signature.headOption == Some(TemporalSignature.timeSort))

  /** @return This TemporalSignature with a different time frame. */
  def setTimeRange(newStart: Int, newEnd: Int): Signature =
    signature.setConstants(Map(TemporalSignature.timeSort -> (newStart to newEnd).map(t => Constant(t.toString,TemporalSignature.timeSort)).toSet))

  def getTimeRange: (Int,Int) = {
    val range = signature.constants(TemporalSignature.timeSort).map(_.name.toInt).toSeq.sorted
    (range.head, range.last)
  }
}

object TemporalSignature {
  /** Return a set of numeric constants of sort time in the given range. */
  def timeRange(begin: Int, end: Int): Seq[Constant] =
    (begin to end).map(n => Constant(n.toString, timeSort))

  val timeSort = Sort("Time")

  implicit def fromSignature(signature: Signature): TemporalSignature = {
    require(signature.constants.contains(timeSort), "Signature must contain 'Time' sort to be turned into dynamic")

    new TemporalSignature(signature)
  }
}

