package edu.uulm.scbayes.logic

sealed trait Term {
  def substituteVariable(term: Term, term1: Term): Term
  def isGround: Boolean
  def getVariables: Set[Variable]
  /** Important: We assume, that this function returns terms whose sort is the same as the sort of this. */
  def extractTermsT: Seq[Term]
}

class Variable(val name: String) extends Term{
  override def toString = name
  override def equals(o: Any) = o match{
    case Variable(n2) => n2 == name
    case _ => false
  }
  override def hashCode = name.hashCode

  def isGround = false

  def getVariables: Set[Variable] = Set(this)
  def substituteVariable(term: Term, term1: Term): Term = {
    if(this == term) term1 else this
  }

  def extractTermsT: Seq[Term] = Seq(this)
}

object Variable{
  def apply(n: String) = new Variable(n)
  def unapply(v: Variable): Some[String] = Some(v.name)
}

case class Constant(name: String, sort: Sort) extends Term{
  override def toString = name
  def isGround = true
  val memoHashCode = name.hashCode ^ sort.hashCode

  override def hashCode: Int = memoHashCode

  def getVariables: Set[Variable] = Set()
  def substituteVariable(term: Term, term1: Term): Term = {
    if(this == term) term1 else this
  }

  def extractTermsT: Seq[Term] = Seq(this)
}

case class Succ(argument: Term) extends Term {
  def isGround = argument.isGround
  def getVariables: Set[Variable] = argument.getVariables
  def substituteVariable(term: Term, term1: Term): Term = {
    if(this == term) term1 else Succ(argument.substituteVariable(term, term1))
  }

  def extractTermsT: Seq[Term] = Seq(this) ++ argument.extractTermsT
}

case class FAdd(argument: Term, value: Int) extends Term {
  def isGround = argument.isGround
  def getVariables: Set[Variable] = argument.getVariables
  def substituteVariable(term: Term, term1: Term): Term = {
    if(this == term) term1 else FAdd(argument.substituteVariable(term, term1), value)
  }

  def extractTermsT: Seq[Term] = Seq(this) ++ argument.extractTermsT
}