package edu.uulm.scbayes.logic.cnf.sampling

/** If the value is negative, this is a binary change item. -1 is true and -2 is false. */
case class CNFWalkChange(base: Int, value: Int){
  def isBinary = value < 0
  def binaryValue = if(value == -1) true else if(value == -2) false else throw new RuntimeException("you have a bug!")
}

object CNFWalkChange {
  def fromBinBase(base: Int, value: Boolean): CNFWalkChange = CNFWalkChange(base, if(value) -1 else -2)
  def fromMVBase(base: Int, value: Int): CNFWalkChange = CNFWalkChange(base, value)
}

