package edu.uulm.scbayes.logic.cnf.sampling

import util.Random
import edu.uulm.scbayes.logic._
import cnf.GroundCNF

/**
 * This is a mutable class that represents an assignment to a CNF problem. It is used for sat sampling.
 */
trait MutableCNFAssignment{
  def cnf: GroundCNF
  def domain: ConstantDomain

  /**
   * This returns an Interpretation, that reflects the current state of this assignment. It is mutable and will change
   * when this object is mutated.
   *
   * Be careful what you do with this object, since the isDefined method always returns true!
   */
  def interpretation: Interpretation

  def baseAssignment: AtomBaseAssignment

  /** Generate a new randomized assignment. */
  def randomize(random: Random)

  def isSatisfied: Boolean

  /** This method makes a copy of the current assignment. If you only need an interpretation use `interpretation`. */
  def truthAssignment: TruthAssignment

  def atomBases: Seq[AtomBase]

  def setBase[B <: AtomBase](ab: B, newVal: B#RangeType)

  def set(ta: AtomBaseAssignment) {
    for(
      ab <- atomBases;
      newVal <- ta.baseValue(ab)
    ) {
      setBase(ab, newVal)
    }
  }
}
