package edu.uulm.scbayes.logic.cnf.sampling

import util.Random
import edu.uulm.scbayes.logic._
import edu.uulm.scbayes.logic.cnf._

/**
 * Implementation of SampleSAT algorithm described in [1].
 *
 * This implementation is extended to multivalued atoms.
 *
 * [1] Wei, W.; Erenrich, J. & Selman, B. Towards efficient sampling: Exploiting random walk strategies
 *
 * @tparam C type of clause
 * @tparam A type of atom
 *
 *
 * Date: 25.03.11
 */
class SampleSAT(val pGreedy: Double = 0.5, val temperature: Double = 0.1, val maxSteps: Int = 100, val numIgnoreSolutions: Int = 5) extends SATSampler {

  val restarts = 10
  def samplePartialIntern(cnf: GroundCNF, signature: ConstantDomain, rnd: Random): Option[TruthAssignment] = {
    if(cnf.unconditionalValue.isDefined) return Some(TruthAssignment.empty)

    val state = new ArrayCNFWalker(cnf,signature)
//    val state = new SampleSatState(cnf, signature, rnd)

    var remainingRestarts = restarts

    while(remainingRestarts > 0){

      state.randomize(rnd)
      var ignoreSolutions = numIgnoreSolutions
      var steps = 0

      while (steps < maxSteps && ignoreSolutions >= 0) {
        state.sampleSAT(rnd,pGreedy,temperature)
        if(state.isSatisfied)
          ignoreSolutions -= 1
        steps += 1
      }

      if (state.isSatisfied)
        return Some(state.truthAssignment)

      remainingRestarts -= 1
    }

    None
  }
}