package edu.uulm.scbayes.mln

import edu.uulm.scbayes.logic.{Variable, Formula}


/**
 * A weighted formula that has either a weight as a Double or is a hard constraint.
 */

case class MLNWeightedFormula(formula: Formula, weight:Option[Double], variableInequalities: Set[(Variable, Variable)] = Set()){
  def toParseableString: String = this.toString

  override def toString = weight match {
    case None => "%s.".format(formula)
    case Some(w) => "%.2f %s".format(w,formula)
  }
}