package edu.uulm.scbayes.mln.factorgraph

import edu.uulm.scbayes.probabilities.DiscreteMarginals
import edu.uulm.scbayes.logic.{TruthAssignment, FunctionalAtom, PredicateAtom}

/**
 * This trait is implemented by classes, that are able to compute marginal distributions over discrete variables.
 *
 *
 * Date: 29.03.11
 */

class TruthAssignmentMarginals(val ta: TruthAssignment) extends DiscreteMarginals[LogicNode] {
  def marginal(rv: LogicNode, value: Int): Double = {
    val atom = rv match {
      case pn @ PredicateNode(pab) => PredicateAtom(pab, pn.int2Domain(value))
      case fvn @ FunctionValuedNode(fab, _) => FunctionalAtom(fab, fvn.int2Domain(value))
    }
    val result = if(ta(atom)) 1d else 0d
    result
  }

  def canInfer(v: LogicNode): Boolean = v match {
    case pn: PredicateNode => ta.truth.isDefinedAt(pn.atomBase)
    case fn: FunctionValuedNode => ta.functionValue.isDefinedAt(fn.atomBase)
  }
}