package edu.uulm.scbayes.mln.parsing

import FOLParser._
import edu.uulm.scbayes.logic._
import java.io.FileReader
import edu.uulm.scbayes.mln.{MLNWeightedFormula, MarkovLogicNetwork}
import util.parsing.combinator.Parsers

/**
 * Some special parsers for usage in tests.
 *
 * Date: 17.03.11
 */

object ParseHelpers{
  /**
   * Unwraps a ParseResult and throws a meaningful exception if the parsing was not successful.
   */
  def unpack[A,P <: Parsers](pr: P#ParseResult[A]): A =
    this synchronized {
      try {
        pr.get
      } catch {
        case _: Throwable => throw new RuntimeException("Parse error: %s" format pr)
      }
    }

  /**
   * Parse some predicate definitions followed by some formulas.
   */
  @deprecated("Use other methods instead")
  def parseLogicFormulas(s: String)(implicit sm: SignatureBuilder) = {
    def logicFileParser = ((rep(predicateDefinition) ~ rep(domainDefinition))~> rep1(formula(sm.getSignature)))
    unpack(FOLParser.parseAll(logicFileParser,s))
  }

  def parsePredicateDefs(s: String)(implicit sm: SignatureBuilder) =
    unpack(FOLParser.parseAll(rep1(predicateDefinition),s))

  def parseDomains(s: String)(implicit sm: SignatureBuilder) =
    unpack(FOLParser.parseAll(rep1(domainDefinition),s))

  def parseFormulas(s: String, sig: Signature): List[Formula] =
    unpack(FOLParser.parseAll(rep1(formula(sig)),s))

  def parseFormula(s: String, sig: Signature): Formula =
    unpack(FOLParser.parse(formula(sig),s))

  def parseWeightedFormulas(s: String, sig: Signature): List[MLNWeightedFormula] =
    unpack(FOLParser.parseAll(rep1(weightedFormula(sig)),s))

  def parseMLN(s: String): (Signature, List[MLNWeightedFormula]) = {
    val sb = new SignatureBuilder
    unpack(FOLParser.parseAll(mlnFileParser(sb),s))
  }

  def loadMLNFile(file: String): MarkovLogicNetwork = {
    implicit val sb = new SignatureBuilder

    val in: FileReader = new FileReader(file)

    val (signature, formulaList) = try{
      unpack(FOLParser.parseAll(mlnFileParser, in))
    } catch {
      case e: Exception => throw new RuntimeException("Error while parsing mln file " + file,e)
    } finally {
      in.close()
    }
    MarkovLogicNetwork(formulaList, signature)
  }

  def parseEvidence(s: String, signature: Signature): TruthAssignment = {
    val (ta,constants) = unpack(FOLParser.parseAll(multipleEvidence(signature),s))
    assert(constants.isEmpty, "parsing of evidence file created new constants")
    ta
  }

  def loadEvidenceFile(file: String, signature: Signature): TruthAssignment = {
    val (ta,constants) = unpack(FOLParser.parseAll(multipleEvidence(signature), new FileReader(file)))
    assert(constants.isEmpty, "parsing of evidence file created new constants")
    ta
  }

  def parseEvidenceAllowNewConstants(s: String, signature: Signature): (TruthAssignment,Seq[Constant]) = {
    unpack(FOLParser.parseAll(multipleEvidence(signature),s))
  }

  def loadEvidenceFileAllowNewConstants(file: String, signature: Signature): (TruthAssignment,Seq[Constant]) = {
    unpack(FOLParser.parseAll(multipleEvidence(signature), new FileReader(file)))
  }

}