package edu.uulm.scbayes.probabilities

/**
 * Delegates the computation of marginal probabilities to two other Marginals objects.
 *
 *
 * Date: 29.03.11
 */

class JointMarginals[V <: DiscreteVariable](val infererA: DiscreteMarginals[V],
                                          val infererB: DiscreteMarginals[V]) extends DiscreteMarginals[V]{
  def marginal(rv: V, value: Int): Double =
    (if(infererA.canInfer(rv)) infererA.marginal(rv,value)
    else infererB.marginal(rv,value))

  def canInfer(v: V): Boolean = infererA.canInfer(v) || infererB.canInfer(v)
}

object JointMarginals {
  def apply[V <: DiscreteVariable](ms: DiscreteMarginals[V]*): DiscreteMarginals[V] = {
    if(ms.isEmpty)
      DiscreteMarginals.empty[V]
    else
      ms.tail.foldLeft(ms.head)(new JointMarginals(_,_))
  }
}



