package edu.uulm.scbayes.probabilities

import edu.uulm.scbayes.util._

/**
 * Creates the mean over a sequence of DiscreteMarginal objects.
 */

class MeanMarginals[V <: DiscreteVariable](inferers: Seq[DiscreteMarginals[V]]) extends DiscreteMarginals[V]{
  require(!inferers.isEmpty, "must supply at least one inferer")

  def marginal(rv: V, value: Int): Double = inferers.map(_.marginal(rv,value)).mean

  def canInfer(v: V): Boolean = inferers.head.canInfer(v)
}