package edu.uulm.scbayes.probabilities.statistics

import edu.uulm.scbayes.probabilities._

/**
 * Compares some marginals for a set of variables and computes the corrected variance statistics over the various
 * marginal values for each variable and returns the maximum variance that occurred at one variable.
 *
 *
 * Date: 19.05.11
 */

object MarginalVarianceTester {
  def mean(s: Iterable[Double]) = s.sum / s.size
  def variance(s: Iterable[Double]) = {
    val mean_s: Double = mean(s)
    s.map(_ - mean_s).map(x => x * x).sum / (s.size - 1)
  }
  /**
   * Calculate the variance of the marginals computed by the given inferers for the given random variable and value.
   */
  def univariateVariance[V <: DiscreteVariable](inferers: Iterable[DiscreteMarginals[V]], variable: V, value: Int): Double = {
    variance(inferers.map{_.marginal(variable,value)})
  }

  def maxVariance[V <: DiscreteVariable](inferers: Seq[DiscreteMarginals[V]], variables: Iterable[V]): Double = {
    if(variables.isEmpty) return 0
    (for(rv <- variables; value <- rv.getRange) yield univariateVariance(inferers,rv,value)).max
  }

  def meanVariance[V <: DiscreteVariable](inferers: Seq[DiscreteMarginals[V]], variables: Iterable[V]): Double = {
    if(variables.isEmpty) return 0
    mean(for(rv <- variables; value <- rv.getRange) yield univariateVariance(inferers,rv,value))
  }

}
