package edu.uulm.scbayes.util

import scala.collection.mutable

/**
 * Extension of a mutable map that carries a temporary update.
 *
 *
 * Date: 3/25/11
 */

class HashMapAssignment[A,B] extends collection.mutable.Map[A,B] {

  private val data = new mutable.HashMap[A,B]
  private var temporary: Option[Map[A,B]] = None

  def temporaryUpdate(tm: Map[A,B]) {temporary = Some(tm)}

  def revert() {temporary = None}

  override def clear() {data.clear(); temporary = None}

  def immutableCopy = data.toMap

  def iterator: Iterator[(A, B)] = data.iterator ++ temporary.getOrElse(Map.empty).iterator

  def get(key: A): Option[B] = temporary.flatMap(_.get(key)).orElse(data.get(key))

  def -=(key: A) = {data -= key; this}

  def +=(kv: (A, B)) = {data += kv; this}
}

