package edu.uulm.scbayes.factorgraph

import org.specs2._
import edu.uulm.scbayes.experiments.examples.ExampleGraphs
import edu.uulm.scbayes.inference.TestUtils._
import edu.uulm.scbayes.probabilities.DiscreteVariable
import edu.uulm.scbayes.inference.junctiontree.JunctionTreeInference
import specification.{Tags, Fragments}

class CombineFactorsTest extends Specification with Tags {
  def is: Fragments =
  "compare marginals of graph hardSmokers with combined version" ! compare(ExampleGraphs.pascalCrystal,0.01,50) ^ tag("expensive")

  def compare[V <: DiscreteVariable,F <: DiscreteFactor[V]](graph: DiscreteFactorGraph[V,F], tolerance: Double, rounds: Int) = {
    val combinedGraph = graph.combineFactors
    JunctionTreeInference.infer(combinedGraph) must beCloseMarginals(JunctionTreeInference.infer(graph), tolerance, graph.variables)
  }
}