package edu.uulm.scbayes.inference.bp

import org.specs2.mutable._

import edu.uulm.scbayes.experiments.examples.ExampleGraphs
import edu.uulm.scbayes.inference.exact.CountingInferer
import edu.uulm.scbayes.inference.TestUtils._
import util.Random
import edu.uulm.scbayes.mln.factorgraph.MLNFactorGraph

class BeliefPropagationTest extends Specification {

  //Systems Under Specification start here

  def testOnGraph(graph: MLNFactorGraph, tolerance: Double, rounds: Int) = {
    val bp = Iterator.iterate(
      FloodingBeliefPropagationStepper.createInitialState(graph, graph.variables.toSet, new Random(42))
    )(
      FloodingBeliefPropagationStepper.advanceState
    )

    val bpMarginals = FloodingBeliefPropagationStepper.marginals(bp.drop(rounds).next())

    val exact = new CountingInferer(graph)

     bpMarginals must beCloseMarginals(exact, tolerance, graph.variables)
  }

  "100 steps of BP in simpleFunctional" in {
    val graph = ExampleGraphs.simpleFunctional

    testOnGraph(graph, 0.03, 100)
  }

  "100 steps of BP in smokers" in {
    val graph = ExampleGraphs.smokers

    testOnGraph(graph, 0.05, 100)
  }
}