package edu.uulm.scbayes.inference.incremental

import org.specs2.mutable._

import scala.util.Random
import edu.uulm.scbayes.experiments.examples.ExampleGraphs
import edu.uulm.scbayes.inference.bp.BeliefPropagation
import edu.uulm.scbayes.mln.factorgraph.{WeightedFormulaFactor, LogicNode}

class EFBPTest extends Specification {
  "efbp must wake one variable per iteration in linearSeq example" in {
    //this test should wake one variable on each iteration of efbp on the linear graph
    /*
    Structure of the graph is the following. We only activate V0 initially.

              F1A        F2A
    F0 - V0 <     > V1 <     > V2 ...
              F1B        F2B
     */
    val graph = ExampleGraphs.linearSeqMLN.graph
    val random = new Random(41)

    val stepper = new SteppingEFBP(new DifferenceMessageThreshold(0.00001))

    val initialState: stepper.TState[LogicNode, WeightedFormulaFactor] =
      (
        graph,
        Set(graph.variables.find(_.toString == "p(0)").get), //this is the first node in the graph
        Set.empty[WeightedFormulaFactor],
        BeliefPropagation.createInitialFactorMessages(graph, BeliefPropagation.randomMessageGenerator(random)),
        BeliefPropagation.createInitialVariableMessages(graph, BeliefPropagation.randomMessageGenerator(random))
        )

    val iterator = Iterator.iterate(initialState)(stepper.advanceState).zipWithIndex

    val result = iterator.map{ case (state, idx) => (state._2.size, state._3.size) }.take(10).toSeq
    val reference = (0 to 9).map(i => (i+1,if(i == 0) 0 else i * 2 + 1))

    result must be_==(reference)
  }
}