package edu.uulm.scbayes.inference.junctiontree

import org.specs2.Specification
import org.specs2.specification.Fragments
import edu.uulm.scbayes.probabilities.DiscreteVariable

class JTMessageTest extends Specification {
  implicit def intSeq2Vars(is: Seq[Int]): IndexedSeq[DiscreteVariable] = is.toIndexedSeq.zipWithIndex.map{case (size,idx) => new DiscreteVariable {
    def domainSize: Int = size
    override def valueName(i: Int): String = "V" + idx
  }}

  def is: Fragments =
  "normalized log JTMessage must sum to one" ! (JTMessage(Seq(2,2), Array(-34,12,0,2.4), true).normalized.values.map(math.exp).sum must beCloseTo(1d, 0.001)) ^
  "normalized not-log JTMessage must sum to one" ! (JTMessage(Seq(2,2), Array(3.4,12,0,2.4), false).normalized.values.sum must beCloseTo(1d, 0.001))
}