package edu.uulm.scbayes.inference.junctiontree

import org.specs2._
import edu.uulm.scbayes.experiments.examples.ExampleGraphs
import edu.uulm.scbayes.inference.exact.CountingInferer
import edu.uulm.scbayes.mln.factorgraph.{LogicNode, WeightedFormulaFactor, MLNFactorGraph}
import edu.uulm.scbayes.inference.TestUtils._
import edu.uulm.scbayes.mln.parsing.ParseHelpers
import edu.uulm.scbayes.logic.TruthAssignment
import specification.{Tags, Fragments}

class JunctionTreeInferenceTest extends Specification with Tags {

  def is: Fragments = args(sequential=true) ^
    "compare junction tree inference to counting inference on smokers" ! cmpCountingJT(ExampleGraphs.smokers).pendingUntilFixed("junction tree is broken") ^
    "compare junction tree inference to counting inference on smokers with evidence" ! cmpCountingJT(ExampleGraphs.smokersWithEvidence).pendingUntilFixed("junction tree is broken") ^
    "compare junction tree inference to counting inference on simple" ! cmpCountingJT(ExampleGraphs.simple).pendingUntilFixed("junction tree is broken") ^
    //the following doesn't work because the domain is too large, so that more than Int.MAX_VALUE interpretations exist. Currently not possible (and never feasible?)
    //"compare junction tree inference to counting inference on pascal crystals" ! cmpCountingJT(ExampleGraphs.pascalCrystal) ^ tag("expensive")
    "compare junction tree inference to counting inference on buggy MCSAT slice inference MLN" ! cmpCountingJT(
      ParseHelpers.loadMLNFile("test-rsc/mlns/mcsat-bug.mln").toGraph(TruthAssignment.empty)
    ).pendingUntilFixed("junction tree is broken") ^ tag("expensive")


  def cmpCountingJT(graph: MLNFactorGraph) = {
    val counting = new CountingInferer(graph)
    val jt = JunctionTreeInference.inferMarginals[LogicNode,WeightedFormulaFactor](graph)
    jt must beCloseMarginals(counting, 0.0001, graph.variables)
  }
}