package edu.uulm.scbayes.inference.sampling


import scala.util.Random
import edu.uulm.scbayes.experiments.examples.ExampleGraphs
import edu.uulm.scbayes.logic.cnf.sampling.{SampleSAT, RejectionSAT}
import org.specs2.Specification
import edu.uulm.scbayes.inference._
import org.specs2.specification.{Fragments, Tags}

/**
 * Tests for the MCSAT inference algorithm.
 *
 * Date: 28.03.11
 */

class MCSATTest extends Specification with Tags {

  def is: Fragments = buildFragments

  def buildFragments: Fragments = {
    val fragments = for((infDesc, inferer) <- inferers; (pDesc, problem) <- problems) yield
      infDesc + " on " + pDesc ! (inferer must TestUtils.inferAsJT(problem, 0.03)) ^ tag("expensive")
    fragments.reduce(_ ^ _)
  }

  val problems = Seq(
    "smokers with evidence" -> ExampleGraphs.smokersWithEvidence,
    "smokers" -> ExampleGraphs.smokers,
    "simple functional" -> ExampleGraphs.simpleFunctional
  )
  val inferers = Seq(
    "5k steps with RejectionSAT and w/o unit propagation" -> new MutableMCSatInferer(new RejectionSAT, false).forSteps(5000, new Random(42)),
    "5k steps with RejectionSAT and w/ unit propagation" -> new MutableMCSatInferer(new RejectionSAT, true).forSteps(5000, new Random(42)),
    "5k steps with SampleSAT and w/o unit propagation" -> new MutableMCSatInferer(new SampleSAT, false).forSteps(5000, new Random(43)),
    "5k steps with SampleSAT and w/ unit propagation" -> new MutableMCSatInferer(new SampleSAT,true).forSteps(5000, new Random(43))
  )
}