package edu.uulm.scbayes.inference.sampling

import edu.uulm.scbayes.mln.parsing.ParseHelpers
import edu.uulm.scbayes.inference._
import util.Random
import org.specs2.Specification
import edu.uulm.scbayes.logic.cnf.sampling.RejectionSAT
import edu.uulm.scbayes.mln.factorgraph.MLNFactorGraph
import TestUtils._
import org.specs2.specification.{Tags, Fragments}

/**
 * These tests are created for finding the bug that appeared in temporal slice inference using MCSAT.
 *
 *
 * Date: 21.11.11
 */

class MCSATWrongInferenceTest extends Specification with Tags {
  val buggyMLN: MLNFactorGraph = ParseHelpers.loadMLNFile("test-rsc/mlns/mcsat-bug.mln").toGraph()
  val strippedMLN = ParseHelpers.loadMLNFile("test-rsc/mlns/mcsat-bug-stripped.mln").toGraph()

  def mcsat(steps: Int) = (new MutableMCSatInferer(new RejectionSAT)).forSteps(steps, new Random(42))

  def is: Fragments =
    "MCSAT with RejectionSAT should find same marginals as JunctionTree on buggy MLN" ! (mcsat(5000) must inferAsJT(buggyMLN, 0.03)).pendingUntilFixed("junction tree is broken") ^ tag("expensive") ^
  "MCSAT with RejectionSAT should find same marginals as JunctionTree on MLN containing unnegated literal with negative weight" ! (mcsat(500) must inferAsJT(strippedMLN, 0.03))
}