package edu.uulm.scbayes.inference.sampling.sat

import org.specs2.Specification
import org.specs2.specification.Fragments
import edu.uulm.scbayes.logic.cnf.sampling.ArrayCNFAssignment
import edu.uulm.scbayes.inference.TestUtils._
import util.Random
import collection.immutable.IndexedSeq
import org.specs2.matcher.{MatchResult, DataTables}

class MutableSATAssignmentTest extends Specification with DataTables {
  def is: Fragments =
    "satisfaction tests for propositional formulas" ! e1 ^
    "satisfaction tests for MutableSATAssignment" ! muSatTest ^
      {
        val (cnf, sig) = parsePropCNF("!a3=1 ^ (!a3=2 v b) ^ (!b v a3=0 v a3=1) ^ (!c v !b) ^ (!b5=3 v !b5=3 v b5=0 v b) ^ (b5=2 v a3=1)")
        val muSat = new ArrayCNFAssignment(cnf,sig)
        val rand = new Random(42)

        val randomTests: IndexedSeq[MatchResult[Any]] = for(i <- 1 to 10000) yield {
          muSat.randomize(rand)
          cnf.evaluate(muSat.truthAssignment) mustEqual muSat.isSatisfied
        }

        randomTests.reduce(_ and _)
      }

  val satisfactionTable = "formula" || "assignment" | "ok" |
    "a v b"                                   !! "a"       ! true  |
    "a v b"                                   !! "b"       ! true  |
    "a v b"                                   !! "c"       ! false |
    "a ^ (!b v c)"                            !! "c"       ! false |
    "a ^ (!b v c)"                            !! "a,c"     ! true  |
    "a3=1"                                    !! "a3=2"    ! false |
    "a3=1"                                    !! "a3=1"    ! true  |
    "!a3=1"                                   !! "a3=1"    ! false |
    "!a3=1"                                   !! "a3=2"    ! true  |
    "a3=1 ^ (!a3=1 v b) ^ (!b v a3=0)"        !! "a3=2,b"  ! false |
    "a3=1 ^ (!a3=1 v b) ^ (!b v a3=0)"        !! "a3=1,!b" ! false |
    "a3=1 ^ (!a3=1 v b) ^ (!b v a3=0 v a3=1)" !! "a3=1,b"  ! true

  def e1 = satisfactionTable |> ((f, a, s) => parsePropCNF(f)._1.evaluate(parsePropAssignment(a)) == s)

  def muSatTest = satisfactionTable |> {(f, a, s) =>
    val (cnf, sig) = parsePropCNF(f)
    val truthAssignment = parsePropAssignment(a)

    val muSat = new ArrayCNFAssignment(cnf,sig)

    muSat.set(truthAssignment)

    muSat.isSatisfied must be_==(s)
  }
}
