package edu.uulm.scbayes.logic

import org.specs2.mutable._

import cnf.dimacs.DIMACSParser
import cnf.sampling.RejectionSAT
import edu.uulm.scbayes.util.benchmarkWallTime
import scala.util.Random

class DIMACSParserTest extends Specification {

  def taHashCode(ta: TruthAssignment, base: Seq[Atom]): Int = {
    //use a fixed seed value
    val rnd = new Random(42)

    base.map(atom => (atom, rnd.nextInt()) ).filter(t => ta(t._1)).foldLeft(0)(_ ^ _._2)
  }

  "a DIMACS file should be parsable" in {
    val instance = DIMACSParser.readFile("test-rsc/sat/uf20-91/uf20-01.cnf")

    instance.numVariables must beEqualTo(20)
    instance.clauses.size must beEqualTo(91)
  }
}