package edu.uulm.scbayes.logic

import edu.uulm.scbayes.mln.parsing.{ParseHelpers, SignatureBuilder}

/**
 * Importing this file allows the conversion of strings into formulas using the unary predicates 'p' and 'q',
 * taking constants of the sorts 'P' and 'Q', respectively. Constant names are 0 - 9 for both sorts.
 *
 *
 * Date: 15.03.11
 */

object FormulaDomain1 {
  val signature: Signature = {
    implicit val sigBuild = new SignatureBuilder
    ParseHelpers.parsePredicateDefs("p(P)")
    ParseHelpers.parsePredicateDefs("q(Q)")
    ParseHelpers.parseDomains("P = {0 - 9}")
    ParseHelpers.parseDomains("Q = {0 - 9}")
    sigBuild.getSignature
  }

  implicit def string2Formula(s: String): Formula = ParseHelpers.parseFormula(s, signature)
  implicit def string2RichFormulaString(s: String) = new {def toFormula: Formula = s}
}
