package edu.uulm.scbayes.logic

import org.specs2.mutable._

import edu.uulm.scbayes.mln.parsing._
import ParseHelpers._
import edu.uulm.scbayes.experiments.examples.ExampleGraphs

/**
 * Testing if grounding of predicates works.
 */
class GroundPredicateTest extends Specification {

  "simple domain" should {
    implicit val sm = new SignatureBuilder
    parsePredicateDefs("p(A) q(A,B)")
    parseDomains("A = {A1,A2} B = {B1,B2}")

    val signature = sm.getSignature

    "grounding existential quantifier" in {
      val formulas = parseFormulas(
        "EXISTS ?x p(?x) => !p(?x)\n" +
        "(p(A1) => !p(A1)) v (p(A2) => !p(A2))", signature
      )

      val f1WithGroundedQuantifier: Formula = formulas(0).groundifyQuantifiers(sm.getSignature.constants)

      f1WithGroundedQuantifier must beEqualTo(formulas(1))
    }

    "building the herbrand base" in {
      val preds = parseFormulas(
      "p(A1) p(A2) q(A1,B1) q(A1,B2) q(A2,B1) q(A2,B2)", signature
      )
      signature.herbrandBase.map(_.toString).toSet must beEqualTo(preds.collect{case p: GroundPredicate => p.toString}.toSet)
    }
  }

  "the herbrand base of simple funcitonal example" should {

    val signature = ExampleGraphs.simpleFunctional.signature
    val base = signature.herbrandBase

    "contain 8 atom bases in total" in {
      base.size must beEqualTo(8)
    }

    "contain 2 ground functional predicate bases" in {
      base.count(_.isInstanceOf[FunctionalAtomBase]) must beEqualTo(2)
    }

    "contain 6 normal ground predicate bases" in {
      base.count(_.isInstanceOf[PredicateAtomBase]) must beEqualTo(6)
    }
  }
}