package edu.uulm.scbayes.logic

import org.specs2.mutable._
import org.specs2.matcher.DataTables

import cnf.{GroundCNF, CNFOps}
import edu.uulm.scbayes.mln.parsing.{ParseHelpers, SignatureBuilder}
import ParseHelpers._
import SSTA._

class SATTest extends Specification with DataTables{
  "simple propagation" in {

    implicit val sm = new SignatureBuilder
    val formulas = parseLogicFormulas(
    """
    pA(A)
    fB(A,B!)

    A = {A,B,C,D}
    B = {X,Y}

    pA(A) ^ (pA(B) v !pA(A))
    """
    )

    val signature = sm.getSignature

    val gcnf = GroundCNF.formulaToGroundCNF(formulas(0))

    val (_,ta) = CNFOps.propagate(gcnf)

    "atom"          || "propagation assignment"  |>
    "pA(A)"         !! Some("true")              |
    "pA(B)"         !! Some("true")              | { (atom, assignment) =>
      ta.stringQuery(atom)(signature) must beEqualTo(assignment)
    }
  }
}