package edu.uulm.scbayes.logic

/**
 * Allows to make plain string queries to a TruthAssignment.
 *
 * Date: 29.04.11
 */

class StringSpeakingTruthAssignment(val ta: TruthAssignment) {
  def stringQuery(s: String)(signature: Signature): Option[String] = {
    signature.normalBase.find(_.toString == s).flatMap(ta.truth.lift).map(_.toString).orElse(
      signature.functionalBase.find(_.toString == s).flatMap(ta.functionValue.lift).map(_.toString)
    )
  }
}

object SSTA {
  implicit def ta2ssta(ta: TruthAssignment) = new StringSpeakingTruthAssignment(ta)
}