package edu.uulm.scbayes.logic

import org.specs2.mutable._
import edu.uulm.scbayes.experiments.examples.ExampleGraphs
import edu.uulm.scbayes.logic.TemporalSignature._

class TemporalSignatureTest extends Specification {
  "simple temporal mln example must have time range from 0 to 20" in {
    val dynSig = ExampleGraphs.simpleTemporalMLN.signature

    dynSig.getTimeRange must beEqualTo((0,9))
  }

  "temporal signature rebasing must work" in {
    val dynSig = ExampleGraphs.simpleTemporalMLN.signature
    dynSig.setTimeRange(10,29).constants(TemporalSignature.timeSort) must be size(20)
  }
}