package edu.uulm.scbayes.logic.cnf

import org.specs2.Specification
import org.specs2.specification.Fragments
/**
 * Test the simplification of ground CNF formulae.
 *
 *
 * Date: 30.08.11
 */

class GroundCNFReductionTest extends Specification {

  def unconditionalVariables(f: String): Set[String] = Set()
  def independentVariables(f: String): Set[String] = Set()

  def is: Fragments =
  args(skipAll = true) ^
  "find variables, that must unconditionally be assigned to a certain value" ^
  "the following tests can be solved by unit propagation" ^
    "a,b fixed in (a v b) ^ !b" ! (unconditionalVariables("(a v b) ^ !b") must containAnyOf(Seq("a","b"))) ^
    "b fixed in (a v c) ^ b" ! (unconditionalVariables("(a v c) ^ b") must containAnyOf("b")) ^
  p^
  "the following tests can be resolved by a 2-consistency check" ^
    "these tests can be resolved by unit propagation following removing 'arbitrary' variables" ^
      "b fixed in (a v b) ^ (!a v b)" ! (unconditionalVariables("(a v b) ^ (!a v b)") must contain("b")) ^
  p^
  "find variables that can be assigned an arbitrary value in every model" ^
    "a independent in (a v !a)" ! (independentVariables("a v !a") must contain("a")) ^
    "a independent in (a v b) ^ (!a v b)" ! (independentVariables("(a v b) ^ (!a v b)") must contain("a"))
}
