package edu.uulm.scbayes.logic.cnf

import org.specs2.mutable._

import edu.uulm.scbayes.mln.parsing.{SignatureBuilder, ParseHelpers}

/**
 * A bunch of equality tests.
 *
 *
 * Date: 23.06.11
 */

class GroundCNFTest extends Specification{

  def createTwoGroundCNFs(formula: String): (GroundCNF, GroundCNF) = {
    implicit val sm = new SignatureBuilder
    ParseHelpers.parsePredicateDefs("p(A)")
    ParseHelpers.parseDomains("A={A,B,C,D}")

    val sig = sm.getSignature

    val formula1 = ParseHelpers.parseFormula(formula, sig)
    val formula2 = ParseHelpers.parseFormula(formula, sig)

    (GroundCNF.formulaToGroundCNF(formula1), GroundCNF.formulaToGroundCNF(formula2))
  }

  "two GroundCNF instances created from the same string must be equal and have the same hashCode" in {
    val (cnf1, cnf2) = createTwoGroundCNFs("p(A) v p(B) ^ !p(C)")

    cnf1 must beEqualTo(cnf2)
    cnf1.hashCode must beEqualTo (cnf2.hashCode)
  }

  "all clauses of two equal GroundCNF instances must be equal" in {
    val (cnf1, cnf2) = createTwoGroundCNFs("p(A) v p(B) ^ !p(C)")

    val clauses1 = cnf1.clauses.toSet
    val clauses2 = cnf2.clauses.toSet

    clauses1 must beEqualTo(clauses2)
  }

  "two equal Clauses of a two GroundCNF instance created from the same string must be equal and have the same hashCode" in {
    val (cnf1, cnf2) = createTwoGroundCNFs("p(A) v p(B)")
    val (clause1, clause2) = (cnf1.clauses.head, cnf2.clauses.head)

    clause1 must beEqualTo(clause2)
    clause1.hashCode must beEqualTo (clause2.hashCode)
  }

  "two FunctionalAtoms created from the same string representation must be equal and have the same hashCode" in {
    val (cnf1, cnf2) = createTwoGroundCNFs("p(A)")
    val (atom1, atom2) = (cnf1.atoms.head, cnf2.atoms.head)

    atom1 must beEqualTo(atom2)
    atom1.hashCode must beEqualTo (atom2.hashCode)
  }
}