package edu.uulm.scbayes.logic.cnf

import org.specs2._
import specification.Fragments
import edu.uulm.scbayes.inference.TestUtils

/**
 * The following formula evaluated to true under the given assignment. Although I think it is not satisfiable.
 *
 *
 * Date: 20.12.11
 */

class WrongEvalTest extends Specification {
  val formulaString =
    "(!at_7_A10=4 v !at_7_B10=4) ^ " +
    "(!at_7_A10=5 v !at_7_B10=5) ^ " +
    "(!at_7_B10=6 v !at_7_A10=6) ^ " +
    "(at_6_A10=6 v at_6_A10=7 v at_7_A10=6) ^ " +
    "(at_6_A10=6 v at_6_A10=7 v at_6_A10=5) ^ " +
    "!at_6_A10=6 ^ " +  //eg this clause is directly violated
    "!at_6_B10=7 ^ " +
    "(!at_7_A10=8 v !at_7_B10=8) ^ " +
    "(!at_7_B10=7 v !at_7_A10=7) ^ " +
    "!at_6_B10=9 ^ " +
    "!at_7_A10=6 ^ " +
    "!at_6_B10=6 ^ " +
    "!at_6_B10=4 ^ " +
    "!at_7_A10=1 ^ " +
    "(at_6_A10=5 v at_6_A10=6 v at_7_A10=5) ^ " +
    "(at_6_A10=5 v at_6_A10=6 v at_6_A10=4) ^ " +
    "!at_6_A10=8 ^ " +
    "(!at_7_A10=6 v !at_7_B10=6) ^ " +
    "!at_6_B10=1 ^ " +
    "!at_7_B10=7 ^ " +
    "!at_6_A10=0 ^ " +
    "(!at_7_A10=2 v !at_7_B10=2) ^ " +
    "!at_6_B10=3 ^ " +
    "(!at_7_B10=3 v !at_7_A10=3) ^ " +
    "!at_6_A10=3 ^ " +
    "(!at_7_B10=4 v !at_7_A10=4) ^ " +
    "!at_6_A10=4 ^ " +
    "!at_7_B10=5 ^ " +
    "!at_7_A10=2 ^ " +
    "!at_6_B10=2 ^ " +
    "!at_7_A10=4 ^ " +
    "(at_6_B10=6 v at_6_B10=7 v at_7_B10=6) ^ " +
    "(at_6_B10=6 v at_6_B10=7 v at_6_B10=5) ^ " +
    "!at_7_A10=3 ^ " +
    "(!at_7_B10=8 v !at_7_A10=8) ^ " +
    "(!at_7_A10=9 v !at_7_B10=9) ^ " +
    "!at_7_A10=7 ^ " +
    "(!at_7_A10=0 v !at_7_B10=0) ^ " +
    "!at_7_B10=2 ^ " +
    "(!at_7_A10=3 v !at_7_B10=3) ^ " +
    "!at_7_B10=3 ^ " +
    "!at_7_B10=1 ^ " +
    "(!at_7_B10=0 v !at_7_A10=0) ^ " +
    "!at_7_A10=5 ^ " +
    "!at_7_B10=8 ^ " +
    "!at_6_A10=7 ^ " +
    "!at_7_B10=9 ^ " +
    "(!at_7_B10=2 v !at_7_A10=2) ^ " +
    "!at_6_B10=5 ^ " + //directly violated
    "!at_6_A10=5 ^ " +
    "(at_6_B10=4 v at_6_B10=5 v at_7_B10=4) ^ " +
    "(at_6_B10=4 v at_6_B10=5 v at_6_B10=3) ^ " +
    "!at_7_B10=0 ^ " +
    "(!at_7_B10=1 v !at_7_A10=1) ^ " +
    "(!at_7_B10=9 v !at_7_A10=9) ^ " +
    "!at_6_B10=8 ^ " +
    "(at_6_B10=5 v at_6_B10=6 v at_7_B10=5) ^ " +
    "(at_6_B10=5 v at_6_B10=6 v at_6_B10=4) ^ " +
    "(!at_7_A10=1 v !at_7_B10=1) ^ " +
    "(!at_7_B10=5 v !at_7_A10=5) ^ " +
    "(!at_7_A10=7 v !at_7_B10=7) ^ " +
    "!at_7_A10=0 ^ " +
    "!at_7_A10=8 ^ " +
    "!at_6_A10=9 ^ " +
    "!at_6_B10=0"

  val assignmentString = "at_6_A10=6,at_6_B10=5,at_7_A10=9,at_7_B10=6"

  val cnf = TestUtils.parsePropCNF(formulaString)._1
  val assignment = TestUtils.parsePropAssignment(assignmentString)

  def is: Fragments =
    (cnf.evaluate(assignment) must_== false)
}