package edu.uulm.scbayes.mln

import factorgraph.{MLNFactorGraph, LogicNode}
import org.specs2._
import parsing.ParseHelpers
import specification.Fragments
import edu.uulm.scbayes.logic.{AtomBase, Atom}
import edu.uulm.scbayes.inference.TestUtils._

class GroundMLNTest extends Specification {
  val mlnFile = "res/mln/social-force-movement/sf-movement.mln"
  val evidenceFile = "res/mln/social-force-movement/sf-movement.db"
  val mln = ParseHelpers.loadMLNFile(mlnFile)
  val evidence = ParseHelpers.loadEvidenceFile(evidenceFile, mln.signature)
  val graph: MLNFactorGraph = mln.toGraph(evidence)

  def is: Fragments =
  "ground MLN factor graph must not contain any of the evidence atoms as variable" !
    (graph.variables.map(_.atomBase) must not(containAnyOf(evidence.asAtoms.toSeq)))
}