/*
 * Decompiled with CFR 0.152.
 */
package de.uniulm.ki.panda3.efficient.search;

import de.uniulm.ki.panda3.efficient.Wrapping;
import de.uniulm.ki.panda3.efficient.plan.EfficientPlan;
import de.uniulm.ki.panda3.efficient.plan.flaw.EfficientFlaw;
import de.uniulm.ki.panda3.efficient.plan.modification.EfficientModification;
import de.uniulm.ki.panda3.symbolic.compiler.ClosedWorldAssumption$;
import de.uniulm.ki.panda3.symbolic.compiler.ToPlainFormulaRepresentation$;
import de.uniulm.ki.panda3.symbolic.domain.Domain;
import de.uniulm.ki.panda3.symbolic.domain.updates.DomainUpdate;
import de.uniulm.ki.panda3.symbolic.parser.xml.XMLParser$;
import de.uniulm.ki.panda3.symbolic.plan.Plan;
import java.io.FileInputStream;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class DFS$ {
    public static final DFS$ MODULE$;
    private long initTime;
    private int nodes;

    static {
        new DFS$();
    }

    public void main(String[] args) {
        String domFile = "src/test/resources/de/uniulm/ki/panda3/symbolic/parser/xml/AssemblyTask_domain.xml";
        String probFile = "src/test/resources/de/uniulm/ki/panda3/symbolic/parser/xml/AssemblyTask_problem.xml";
        Domain domAlone = XMLParser$.MODULE$.parseDomain(new FileInputStream(domFile));
        Tuple2<Domain, Plan> domAndInitialPlan = XMLParser$.MODULE$.parseProblem(new FileInputStream(probFile), domAlone);
        DomainUpdate sortExpansion = domAndInitialPlan._1().expandSortHierarchy();
        Domain parsedDom = domAndInitialPlan._1().update(sortExpansion);
        Plan parsedProblem = domAndInitialPlan._2().update(sortExpansion);
        Tuple2<Domain, Plan> cwaApplied = ClosedWorldAssumption$.MODULE$.transform(parsedDom, parsedProblem);
        Tuple2<Domain, Plan> flattened = ToPlainFormulaRepresentation$.MODULE$.transform(cwaApplied._1(), cwaApplied._2(), BoxedUnit.UNIT);
        Wrapping wrapper = new Wrapping(flattened._1(), flattened._2());
        EfficientPlan initialPlan = wrapper.unwrap(flattened._2());
        Predef$.MODULE$.println(BoxesRunTime.boxToInteger(initialPlan.flaws().length));
        System.in.read();
        this.initTime_$eq(System.currentTimeMillis());
        this.nodes_$eq(0);
        this.dfs(initialPlan, 0);
    }

    public long initTime() {
        return this.initTime;
    }

    public void initTime_$eq(long x$1) {
        this.initTime = x$1;
    }

    public int nodes() {
        return this.nodes;
    }

    public void nodes_$eq(int x$1) {
        this.nodes = x$1;
    }

    public Option<EfficientPlan> dfs(EfficientPlan plan, int depth) {
        Option option;
        if (plan.flaws().length == 0) {
            option = new Some<EfficientPlan>(plan);
        } else {
            if (this.nodes() % 500 == 0 && this.nodes() > 0) {
                long nTime = System.currentTimeMillis();
                double nps = (double)this.nodes() / (double)(nTime - this.initTime()) * (double)1000;
                Predef$.MODULE$.println(new StringBuilder().append((Object)"Plans Expanded: ").append(BoxesRunTime.boxToInteger(this.nodes())).append((Object)" ").append(BoxesRunTime.boxToDouble(nps)).append((Object)" Depth ").append(BoxesRunTime.boxToInteger(depth)).toString());
            }
            this.nodes_$eq(this.nodes() + 1);
            EfficientFlaw[] flaws = plan.flaws();
            int smallFlaw = 0;
            int smallFlawNumMod = 0x3F3F3F3F;
            for (int flawnum = 0; flawnum < flaws.length; ++flawnum) {
                int modnum = flaws[flawnum].estimatedNumberOfResolvers();
                if (modnum >= smallFlawNumMod) continue;
                smallFlawNumMod = modnum;
                smallFlaw = flawnum;
            }
            if (smallFlawNumMod == 0) {
                option = None$.MODULE$;
            } else {
                Option result2 = None$.MODULE$;
                EfficientModification[] resolver = flaws[smallFlaw].resolver();
                for (int modNum = 0; modNum < smallFlawNumMod && ((Option)result2).isEmpty(); ++modNum) {
                    EfficientPlan newPlan = plan.modify(resolver[modNum]);
                    result2 = this.dfs(newPlan, depth + 1);
                }
                option = result2;
            }
        }
        return option;
    }

    private DFS$() {
        MODULE$ = this;
        this.initTime = System.currentTimeMillis();
        this.nodes = 0;
    }
}

