/*
 * Decompiled with CFR 0.152.
 */
package de.uniulm.ki.panda3.progression.TDGReachabilityAnalysis;

import de.uniulm.ki.panda3.progression.TDGReachabilityAnalysis.IActionReachability;
import de.uniulm.ki.panda3.progression.TDGReachabilityAnalysis.IDisjunctiveLandmarks;
import de.uniulm.ki.panda3.progression.TDGReachabilityAnalysis.TarjanSCCs;
import de.uniulm.ki.panda3.progression.TDGReachabilityAnalysis.TaskReachabilityGraph;
import de.uniulm.ki.panda3.progression.htn.representation.ProMethod;
import de.uniulm.ki.panda3.progression.htn.search.ProgressionNetwork;
import de.uniulm.ki.panda3.progression.htn.search.ProgressionPlanStep;
import de.uniulm.ki.panda3.symbolic.domain.Task;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class TDGLandmarkFactory
implements IActionReachability,
IDisjunctiveLandmarks {
    private final int numActions;
    private final int numTasks;
    private int nodeCount;
    private BitSet root = null;
    private BitSet[] graph;
    private int[][] scc;
    private int[] nodeToScc;
    BitSet[] sccTree;
    BitSet[] possible;
    BitSet[] necessary;
    BitSet[] reachableActions;
    BitSet[][] relaxedLandmarks;
    String[] taskNames;
    String[][] taskParams;
    private final String varSymbol = "?";
    HashMap<String, List<String[]>>[] relLMs;

    public static int tToI(Task task) {
        return ProgressionNetwork.taskToIndex.get(task);
    }

    public static Task iToT(int n) {
        return ProgressionNetwork.indexToTask[n];
    }

    public TDGLandmarkFactory(HashMap<Task, List<ProMethod>> hashMap, List<ProgressionPlanStep> list, int n, int n2) {
        int n3;
        System.out.println("Calculating HTN reachability ...");
        long l = System.currentTimeMillis();
        this.numActions = n2;
        this.numTasks = n;
        this.buildAndOrGraph(hashMap, n);
        this.root = new BitSet(this.nodeCount);
        this.root.set(0, this.nodeCount, false);
        for (ProgressionPlanStep progressionPlanStep : list) {
            this.root.set(TDGLandmarkFactory.tToI(progressionPlanStep.getTask()));
        }
        TarjanSCCs tarjanSCCs = new TarjanSCCs(this.graph);
        tarjanSCCs.calcSccs(this.root);
        this.scc = tarjanSCCs.getSCCs();
        this.nodeToScc = tarjanSCCs.getNodeToScc();
        System.out.println(" - Found " + tarjanSCCs.numOfSCCs() + " SCCs with up to " + tarjanSCCs.biggestScc() + " tasks.");
        this.sccTree = this.buildTreeOfSCCs();
        this.necessary = new BitSet[this.nodeCount];
        this.possible = new BitSet[this.nodeCount];
        for (n3 = 0; n3 < this.nodeCount; ++n3) {
            this.necessary[n3] = new BitSet(this.nodeCount);
            this.possible[n3] = new BitSet(this.nodeCount);
        }
        n3 = this.root.nextSetBit(0);
        while (n3 > -1) {
            this.calcPossAndNecSets(this.nodeToScc[n3]);
            n3 = this.root.nextSetBit(n3 + 1);
        }
        this.reachableActions = new BitSet[n];
        for (n3 = 0; n3 < this.reachableActions.length; ++n3) {
            this.reachableActions[n3] = new BitSet(n2);
            this.reachableActions[n3].set(0, n2, false);
            int n4 = this.possible[n3].nextSetBit(0);
            while (n4 > -1 && n4 < n2) {
                this.reachableActions[n3].set(n4);
                n4 = this.possible[n3].nextSetBit(n4 + 1);
            }
        }
        System.out.println(" - Reachability calculated in " + (System.currentTimeMillis() - l) + " ms.");
        assert (this.implementationEquality(hashMap, list, n, n2));
    }

    private void collectRelaxedLMs() {
        Cloneable cloneable;
        int n;
        this.relaxedLandmarks = new BitSet[this.numTasks][];
        for (int i = 0; i < this.numActions; ++i) {
            this.relaxedLandmarks[i] = new BitSet[0];
        }
        HashMap<String, Cloneable> hashMap = new HashMap<String, Cloneable>();
        for (n = 0; n < this.taskNames.length; ++n) {
            if (this.taskNames[n] == null) continue;
            if (hashMap.containsKey(this.taskNames[n])) {
                cloneable = (BitSet)hashMap.get(this.taskNames[n]);
            } else {
                cloneable = new BitSet();
                hashMap.put(this.taskNames[n], cloneable);
            }
            ((BitSet)cloneable).set(n);
        }
        for (n = this.numActions; n < this.numTasks; ++n) {
            cloneable = new ArrayList();
            for (String string2 : this.relLMs[n].keySet()) {
                BitSet bitSet = new BitSet(this.numTasks);
                BitSet bitSet2 = (BitSet)hashMap.get(string2);
                for (String[] stringArray : this.relLMs[n].get(string2)) {
                    int n2 = bitSet2.nextSetBit(0);
                    while (n2 >= 0) {
                        boolean bl = true;
                        assert (this.taskParams[n2].length == stringArray.length);
                        for (int i = 0; i < this.taskParams[n2].length; ++i) {
                            if (stringArray[i].equals("?") || stringArray[i].equals(this.taskParams[n2][i])) continue;
                            bl = false;
                            break;
                        }
                        if (bl) {
                            bitSet.set(n2);
                        }
                        n2 = bitSet2.nextSetBit(n2 + 1);
                    }
                }
                cloneable.add(bitSet);
            }
            this.relaxedLandmarks[n] = new BitSet[cloneable.size()];
            for (int i = 0; i < cloneable.size(); ++i) {
                this.relaxedLandmarks[n][i] = (BitSet)cloneable.get(i);
            }
        }
    }

    private void buildAndOrGraph(HashMap<Task, List<ProMethod>> hashMap, int n) {
        int n2 = n;
        HashMap<ProMethod, Integer> hashMap2 = new HashMap<ProMethod, Integer>();
        for (Task task : hashMap.keySet()) {
            for (ProMethod object : hashMap.get(task)) {
                hashMap2.put(object, n2);
                ++n2;
            }
        }
        this.nodeCount = n + hashMap2.keySet().size();
        this.graph = new BitSet[this.nodeCount];
        for (int i = 0; i < this.nodeCount; ++i) {
            this.graph[i] = new BitSet(this.nodeCount);
            this.graph[i].set(0, this.nodeCount, false);
        }
        for (Task task : hashMap.keySet()) {
            BitSet bitSet = this.graph[TDGLandmarkFactory.tToI(task)];
            for (ProMethod proMethod : hashMap.get(task)) {
                int n3 = (Integer)hashMap2.get(proMethod);
                bitSet.set(n3);
                BitSet bitSet2 = this.graph[n3];
                for (Task task2 : proMethod.subtasks) {
                    bitSet2.set(TDGLandmarkFactory.tToI(task2));
                }
            }
        }
    }

    private BitSet[] buildTreeOfSCCs() {
        BitSet[] bitSetArray = new BitSet[this.scc.length];
        for (int i = 0; i < this.scc.length; ++i) {
            bitSetArray[i] = new BitSet(this.scc.length);
            for (int n : this.scc[i]) {
                int n2 = this.graph[n].nextSetBit(0);
                while (n2 >= 0) {
                    bitSetArray[i].set(this.nodeToScc[n2]);
                    n2 = this.graph[n].nextSetBit(n2 + 1);
                }
            }
            bitSetArray[i].set(i, false);
        }
        return bitSetArray;
    }

    private void calcPossAndNecSets(int n) {
        int n2 = this.sccTree[n].nextSetBit(0);
        while (n2 > -1) {
            this.calcPossAndNecSets(n2);
            n2 = this.sccTree[n].nextSetBit(n2 + 1);
        }
        boolean bl = true;
        while (bl) {
            bl = false;
            for (int n3 : this.scc[n]) {
                BitSet bitSet = (BitSet)this.necessary[n3].clone();
                BitSet bitSet2 = (BitSet)this.possible[n3].clone();
                if (this.isPrimitive(n3)) {
                    this.necessary[n3].set(n3);
                    this.possible[n3].set(n3);
                } else if (this.isAbstract(n3)) {
                    this.processAbsTask(n3);
                } else {
                    this.processMethod(n3);
                }
                if (bitSet.equals(this.necessary[n3]) && bitSet2.equals(this.possible[n3])) continue;
                bl = true;
            }
            if (this.scc[n].length != 1) continue;
            break;
        }
    }

    private void processAbsTask(int n) {
        boolean bl = true;
        int n2 = this.graph[n].nextSetBit(0);
        while (n2 >= 0) {
            if (bl) {
                bl = false;
                this.necessary[n] = (BitSet)this.necessary[n2].clone();
            } else {
                this.necessary[n].and(this.necessary[n2]);
            }
            this.possible[n].or(this.possible[n2]);
            n2 = this.graph[n].nextSetBit(n2 + 1);
        }
        this.necessary[n].set(n);
        this.possible[n].set(n);
    }

    private void processMethod(int n) {
        int n2 = this.graph[n].nextSetBit(0);
        while (n2 >= 0) {
            this.necessary[n].or(this.necessary[n2]);
            this.possible[n].or(this.possible[n2]);
            n2 = this.graph[n].nextSetBit(n2 + 1);
        }
    }

    private void calcRelaxedLMs(int n) {
        int n2 = this.sccTree[n].nextSetBit(0);
        while (n2 > -1) {
            this.calcRelaxedLMs(n2);
            n2 = this.sccTree[n].nextSetBit(n2 + 1);
        }
        boolean bl = true;
        while (bl) {
            bl = false;
            for (int n3 : this.scc[n]) {
                boolean bl2 = false;
                if (this.isPrimitive(n3)) {
                    this.calcRLMsPrimTask(n3);
                } else {
                    bl2 = this.isAbstract(n3) ? this.calcRLMsAbsTask(n3) : this.calcRLMsMethod(n3);
                }
                if (!bl2) continue;
                bl = true;
            }
            if (this.scc[n].length != 1) continue;
            break;
        }
    }

    private void calcRLMsPrimTask(int n) {
        if (this.taskNames[n] == null) {
            this.extractParams(n);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(this.taskParams[n].clone());
        this.relLMs[n].put(this.taskNames[n], arrayList);
    }

    private boolean calcRLMsAbsTask(int n) {
        Cloneable cloneable;
        if (this.taskNames[n] == null) {
            this.extractParams(n);
        }
        HashMap<String, List<String[]>> hashMap = null;
        boolean bl = true;
        int n2 = this.graph[n].nextSetBit(0);
        while (n2 >= 0) {
            if (bl) {
                bl = false;
                hashMap = this.copyLMs(this.relLMs[n2]);
            } else {
                cloneable = new LinkedList<String>();
                for (String string2 : hashMap.keySet()) {
                    if (!this.relLMs[n2].containsKey(string2)) {
                        cloneable.add(string2);
                        continue;
                    }
                    List<String[]> list = hashMap.get(string2);
                    List<String[]> list2 = this.relLMs[n2].get(string2);
                    this.unify(list, list2);
                }
                for (String string2 : cloneable) {
                    hashMap.remove(string2);
                }
            }
            n2 = this.graph[n].nextSetBit(n2 + 1);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(this.taskParams[n].clone());
        hashMap.put(this.taskNames[n], arrayList);
        cloneable = this.relLMs[n];
        this.relLMs[n] = hashMap;
        return !this.equalLmSets((HashMap<String, List<String[]>>)cloneable, hashMap);
    }

    private HashMap<String, List<String[]>> copyLMs(HashMap<String, List<String[]>> hashMap) {
        HashMap<String, List<String[]>> hashMap2 = new HashMap<String, List<String[]>>();
        for (String string2 : hashMap.keySet()) {
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            hashMap2.put(string2, arrayList);
            for (String[] stringArray : hashMap.get(string2)) {
                arrayList.add(stringArray);
            }
        }
        return hashMap2;
    }

    private void unify(List<String[]> list, List<String[]> list2) {
        for (int i = 0; i < list.size(); ++i) {
            int n = Integer.MAX_VALUE;
            String[] stringArray = null;
            for (int j = 0; j < list2.size(); ++j) {
                String[] stringArray2;
                String[] stringArray3 = list.get(i);
                String[] stringArray4 = new String[stringArray3.length];
                int n2 = this.unify(stringArray4, stringArray3, stringArray2 = list2.get(j));
                if (n2 >= n) continue;
                n = n2;
                stringArray = stringArray4;
            }
            if (n < Integer.MAX_VALUE) {
                list.remove(i);
                list.add(i, stringArray);
                continue;
            }
            list.remove(i);
            --i;
        }
    }

    private int unify(String[] stringArray, String[] stringArray2, String[] stringArray3) {
        int n = 0;
        for (int i = 0; i < stringArray2.length; ++i) {
            if (stringArray2[i].equals("?") || stringArray2[i].equals(stringArray3[i])) {
                stringArray[i] = stringArray2[i];
                continue;
            }
            stringArray[i] = "?";
            ++n;
        }
        for (String string2 : stringArray) {
            if (string2.equals("?")) continue;
            return n;
        }
        return Integer.MAX_VALUE;
    }

    private boolean calcRLMsMethod(int n) {
        HashMap<String, List<String[]>> hashMap = this.relLMs[n];
        this.relLMs[n] = new HashMap();
        int n2 = this.graph[n].nextSetBit(0);
        while (n2 >= 0) {
            HashMap<String, List<String[]>> hashMap2 = this.relLMs[n2];
            for (String string2 : hashMap2.keySet()) {
                List<Object> list;
                if (!this.relLMs[n].containsKey(string2)) {
                    list = new ArrayList();
                    this.relLMs[n].put(string2, list);
                } else {
                    list = this.relLMs[n].get(string2);
                }
                for (String[] stringArray : hashMap2.get(string2)) {
                    list.add(stringArray.clone());
                }
            }
            n2 = this.graph[n].nextSetBit(n2 + 1);
        }
        return !this.equalLmSets(hashMap, this.relLMs[n]);
    }

    private boolean equalLmSets(HashMap<String, List<String[]>> hashMap, HashMap<String, List<String[]>> hashMap2) {
        if (hashMap.size() != hashMap2.size()) {
            return false;
        }
        for (String string2 : hashMap.keySet()) {
            if (!hashMap2.containsKey(string2)) {
                return false;
            }
            List<String[]> list = hashMap.get(string2);
            List<String[]> list2 = hashMap2.get(string2);
            if (list.size() != list2.size()) {
                return false;
            }
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i).length != list.get(i).length) {
                    return false;
                }
                for (int j = 0; j < list.get(i).length; ++j) {
                    if (list.get(i)[j].equals(list2.get(i)[j])) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void extractParams(int n) {
        Task task = TDGLandmarkFactory.iToT(n);
        String string2 = task.name();
        if (!string2.contains("[")) {
            this.taskNames[n] = string2;
            this.taskParams[n] = new String[0];
        } else {
            String string3;
            this.taskNames[n] = string3 = string2.substring(0, string2.indexOf("["));
            String string4 = string2.substring(string2.indexOf("["));
            string4 = string4.substring(1, string4.length() - 1);
            String[] stringArray = string4.split(",");
            this.taskParams[n] = stringArray;
        }
    }

    private boolean isAbstract(int n) {
        return n >= this.numActions && n < this.numTasks;
    }

    private boolean isPrimitive(int n) {
        return n < this.numActions;
    }

    @Override
    public BitSet getReachableActions(int n) {
        return this.reachableActions[n];
    }

    @Override
    public BitSet[] getDisjLandmarks(int n) {
        return this.relaxedLandmarks[n];
    }

    private void printDisLMTranslation() {
        for (int i = this.numActions; i < this.numTasks; ++i) {
            System.out.println(ProgressionNetwork.indexToTask[i].name() + " :");
            for (int j = 0; j < this.relaxedLandmarks[i].length; ++j) {
                BitSet bitSet = this.relaxedLandmarks[i][j];
                boolean bl = true;
                int n = bitSet.nextSetBit(0);
                while (n >= 0) {
                    if (bl) {
                        System.out.print(" - ");
                        bl = false;
                    } else {
                        System.out.print("   ");
                    }
                    System.out.println(ProgressionNetwork.indexToTask[n].name());
                    n = bitSet.nextSetBit(n + 1);
                }
            }
        }
    }

    private void printDisLMs() {
        for (int i = this.numActions; i < this.numTasks; ++i) {
            if (this.relLMs[i].size() <= 0) continue;
            System.out.println(ProgressionNetwork.indexToTask[i].name() + " :");
            for (String string2 : this.relLMs[i].keySet()) {
                for (String[] stringArray : this.relLMs[i].get(string2)) {
                    System.out.print(" - " + string2);
                    for (String string3 : stringArray) {
                        System.out.print(" " + string3);
                    }
                    System.out.println();
                }
            }
            System.out.println();
        }
    }

    private void printBS(BitSet[] bitSetArray) {
        for (int i = this.numActions; i < this.numTasks; ++i) {
            if (bitSetArray[i].length() <= 0) continue;
            System.out.println(ProgressionNetwork.indexToTask[i].name() + " :");
            int n = bitSetArray[i].nextSetBit(0);
            while (n >= 0) {
                System.out.println(" - " + ProgressionNetwork.indexToTask[n].name());
                n = bitSetArray[i].nextSetBit(n + 1);
            }
            System.out.println();
        }
    }

    private boolean implementationEquality(HashMap<Task, List<ProMethod>> hashMap, List<ProgressionPlanStep> list, int n, int n2) {
        TaskReachabilityGraph taskReachabilityGraph = new TaskReachabilityGraph(hashMap, list, n, n2);
        for (int i = 0; i < n; ++i) {
            BitSet bitSet;
            BitSet bitSet2 = this.getReachableActions(i);
            if (bitSet2.equals(bitSet = taskReachabilityGraph.getReachableActions(i))) continue;
            return false;
        }
        return true;
    }
}

