/*
 * Decompiled with CFR 0.152.
 */
package de.uniulm.ki.panda3.progression.TDGReachabilityAnalysis;

import java.util.BitSet;
import java.util.LinkedList;

public class TarjanSCCs {
    private BitSet[] graph;
    private int[] S;
    private int iS;
    private BitSet nodesInS;
    private int[] dfs;
    private int[] lowlink;
    private BitSet U;
    private int iScc;
    private int maxdfs;
    private int biggestScc = 0;
    private int[][] scc;
    private int[] nodeToScc;

    public TarjanSCCs(BitSet[] bitSetArray) {
        this.graph = bitSetArray;
        int n = bitSetArray.length;
        this.dfs = new int[n];
        this.lowlink = new int[n];
        this.U = new BitSet(n);
        this.U.set(0, n, false);
        this.S = new int[n];
        this.iS = -1;
        this.nodesInS = new BitSet(n);
        this.nodesInS.set(0, n, false);
        this.scc = new int[n][];
        this.iScc = -1;
        this.nodeToScc = new int[n];
    }

    public void tarjan(int n) {
        this.dfs[n] = this.maxdfs;
        this.lowlink[n] = this.maxdfs++;
        this.S[++this.iS] = n;
        this.nodesInS.set(n, true);
        this.U.set(n, true);
        BitSet bitSet = this.graph[n];
        int n2 = bitSet.nextSetBit(0);
        while (n2 > -1) {
            if (!this.U.get(n2)) {
                this.tarjan(n2);
                this.lowlink[n] = this.min(this.lowlink[n], this.lowlink[n2]);
            } else if (this.nodesInS.get(n2)) {
                this.lowlink[n] = this.min(this.lowlink[n], this.dfs[n2]);
            }
            n2 = bitSet.nextSetBit(n2 + 1);
        }
        if (this.lowlink[n] == this.dfs[n]) {
            LinkedList<Integer> linkedList = new LinkedList<Integer>();
            do {
                n2 = this.S[this.iS--];
                this.nodesInS.set(n2, false);
                linkedList.add(n2);
            } while (n2 != n);
            if (this.biggestScc < linkedList.size()) {
                this.biggestScc = linkedList.size();
            }
            this.scc[++this.iScc] = new int[linkedList.size()];
            int n3 = linkedList.size();
            for (int i = 0; i < n3; ++i) {
                int n4;
                this.scc[this.iScc][i] = n4 = ((Integer)linkedList.removeFirst()).intValue();
                this.nodeToScc[n4] = this.iScc;
            }
        }
    }

    private int min(int n, int n2) {
        if (n < n2) {
            return n;
        }
        return n2;
    }

    public void calcSccs() {
        int n = this.U.nextClearBit(0);
        while (n < this.scc.length) {
            this.tarjan(n);
            n = this.U.nextClearBit(n + 1);
        }
        int[][] nArray = this.scc;
        this.scc = new int[this.iScc + 1][];
        for (int i = 0; i < this.scc.length; ++i) {
            this.scc[i] = nArray[i];
        }
        assert (this.sccsOK());
    }

    public void calcSccs(BitSet bitSet) {
        int n = bitSet.nextSetBit(0);
        while (n > -1) {
            this.tarjan(n);
            n = bitSet.nextSetBit(n + 1);
        }
        int[][] nArray = this.scc;
        this.scc = new int[this.iScc + 1][];
        for (int i = 0; i < this.scc.length; ++i) {
            this.scc[i] = nArray[i];
        }
        assert (this.sccsOK());
    }

    public int[][] getSCCs() {
        return this.scc;
    }

    public int[] getNodeToScc() {
        return this.nodeToScc;
    }

    public int numOfSCCs() {
        return this.iScc + 1;
    }

    public int biggestScc() {
        return this.biggestScc;
    }

    private boolean sccsOK() {
        int n;
        for (n = 0; n < this.nodeToScc.length; ++n) {
            boolean bl = false;
            int[] nArray = this.scc[this.nodeToScc[n]];
            int n2 = nArray.length;
            for (int i = 0; i < n2; ++i) {
                int n3 = nArray[i];
                if (n3 != n) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        for (n = 0; n < this.scc.length; ++n) {
            for (int i : this.scc[n]) {
                if (this.nodeToScc[i] == n) continue;
                return false;
            }
        }
        return true;
    }
}

