/*
 * Decompiled with CFR 0.152.
 */
package de.uniulm.ki.panda3.progression.heuristics.sasp;

import de.uniulm.ki.panda3.progression.TDGReachabilityAnalysis.TarjanSCCs;
import de.uniulm.ki.panda3.progression.heuristics.sasp.SasHeuristic;
import de.uniulm.ki.panda3.progression.htn.representation.SasPlusProblem;
import de.uniulm.ki.panda3.util.fastIntegerDataStructures.UUIntPairPriorityQueue;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class hCausalGraph
extends SasHeuristic {
    private final SasPlusProblem p;
    int[][][][] dtgs;
    BitSet[] masks;
    int[][] rev;
    int[][] cg;
    int[][][] costs;
    boolean[][] done;

    public hCausalGraph(SasPlusProblem sasPlusProblem) {
        this.p = sasPlusProblem;
        long l = System.currentTimeMillis();
        System.out.println("Initializing Causal Graph Heuristic");
        System.out.println("- Building Domain Transition Graphs...");
        List<BitSet>[][] listArray = this.createDTGs(sasPlusProblem);
        System.out.println("- Building Causal Graph...");
        BitSet[] bitSetArray = this.translate(this.createCG(sasPlusProblem, listArray));
        System.out.println("- Pruning graphs");
        this.pruneGraphs(sasPlusProblem, bitSetArray, listArray);
        this.pruneDtgs(listArray);
        System.out.println("- Creating final representation");
        this.dtgs = this.copyToArray(listArray);
        this.cg = this.copyToArray(bitSetArray);
        this.rev = this.calcInverseMapping(this.cg);
        this.masks = this.createBitMasks(this.rev);
        this.dotIt(sasPlusProblem, "/home/dh/Schreibtisch/dot/");
        System.out.println("- Prepared heuristic in " + (System.currentTimeMillis() - l) + "ms");
    }

    @Override
    public int calcHeu(BitSet bitSet, BitSet bitSet2) {
        int n;
        this.costs = new int[this.p.numOfVars][][];
        this.done = new boolean[this.p.numOfVars][];
        for (n = 0; n < this.done.length; ++n) {
            this.done[n] = new boolean[this.p.ranges[n]];
        }
        n = 0;
        int n2 = bitSet2.nextSetBit(0);
        while (n2 >= 0) {
            int n3 = this.p.indexToMutexGroup[n2];
            int n4 = bitSet.nextSetBit(this.p.firstIndex[n3]) - this.p.firstIndex[n3];
            assert (n4 <= this.p.lastIndex[n3]);
            int n5 = n2 - this.p.firstIndex[n3];
            this.computeCosts(bitSet, n3, n4);
            if (this.undefined(n3, n4) || this.costs[n3][n4][n5] == Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            n += this.costs[n3][n4][n5];
            n2 = bitSet2.nextSetBit(n2 + 1);
        }
        return n;
    }

    private boolean undefined(int n, int n2) {
        return this.costs[n] == null || this.costs[n][n2] == null;
    }

    private void computeCosts(BitSet bitSet, int n, int n2) {
        if (this.done[n][n2]) {
            return;
        }
        System.out.println(this.p.varNames[n] + " val: " + this.p.factStrs[this.p.firstIndex[n] + n2]);
        this.initCosts(n, n2);
        BitSet[] bitSetArray = new BitSet[this.p.ranges[n]];
        bitSetArray[n2] = (BitSet)bitSet.clone();
        bitSetArray[n2].and(this.masks[n]);
        UUIntPairPriorityQueue uUIntPairPriorityQueue = new UUIntPairPriorityQueue();
        uUIntPairPriorityQueue.add(0, n2 + this.p.firstIndex[n]);
        boolean[] blArray = new boolean[this.p.ranges[n]];
        while (!uUIntPairPriorityQueue.isEmpty()) {
            int n3 = uUIntPairPriorityQueue.minPair()[1];
            int n4 = n3 - this.p.firstIndex[n];
            if (blArray[n4]) continue;
            blArray[n4] = true;
            for (int i = this.p.firstIndex[n]; i <= this.p.lastIndex[n]; ++i) {
                int[][] nArray;
                int n5 = i - this.p.firstIndex[n];
                if (blArray[n5]) continue;
                block2: for (int[] nArray2 : nArray = this.dtgs[n3][i]) {
                    int n6;
                    int n7;
                    int n8 = 1;
                    for (int n9 : nArray2) {
                        n7 = this.p.indexToMutexGroup[n9];
                        n6 = n9 - this.p.firstIndex[n7];
                        assert (this.contains(this.rev[n], n7));
                        int n10 = bitSetArray[n4].nextSetBit(this.p.firstIndex[n7]) - this.p.firstIndex[n7];
                        assert (n10 >= 0);
                        assert (n10 <= this.p.lastIndex[n7]);
                        this.computeCosts(bitSet, n7, n10);
                        if (this.costs[n7][n10][n6] >= Integer.MAX_VALUE) continue block2;
                        n8 += this.costs[n7][n10][n6];
                    }
                    assert (n8 < Integer.MAX_VALUE);
                    if (this.costs[n][n2][n4] + n8 >= this.costs[n][n2][n5]) continue;
                    this.costs[n][n2][n5] = this.costs[n][n2][n4] + n8;
                    bitSetArray[n5] = (BitSet)bitSetArray[n4].clone();
                    for (int n9 : nArray2) {
                        n7 = this.p.indexToMutexGroup[n9];
                        n6 = bitSetArray[n5].nextSetBit(this.p.firstIndex[n7]);
                        assert (n6 >= 0);
                        assert (n6 <= this.p.lastIndex[n7]);
                        bitSetArray[n5].set(n6, false);
                        bitSetArray[n5].set(n9, true);
                    }
                    uUIntPairPriorityQueue.add(this.costs[n][n2][n5], n5 + this.p.firstIndex[n]);
                }
            }
        }
        this.done[n][n2] = true;
    }

    private boolean contains(int[] nArray, int n) {
        for (int n2 : nArray) {
            if (n2 != n) continue;
            return true;
        }
        return false;
    }

    private void initCosts(int n, int n2) {
        if (this.costs[n] == null) {
            this.costs[n] = new int[this.p.ranges[n]][];
        }
        this.costs[n][n2] = new int[this.p.ranges[n]];
        for (int i = 0; i < this.costs[n][n2].length; ++i) {
            this.costs[n][n2][i] = n2 == i ? 0 : Integer.MAX_VALUE;
        }
    }

    private List<BitSet>[][] createDTGs(SasPlusProblem sasPlusProblem) {
        int n;
        int n2;
        List[][] listArrayArray = new List[sasPlusProblem.numOfStateFeatures][];
        for (n2 = 0; n2 < sasPlusProblem.numOfStateFeatures; ++n2) {
            listArrayArray[n2] = new List[sasPlusProblem.numOfStateFeatures];
            for (n = 0; n < sasPlusProblem.numOfStateFeatures; ++n) {
                listArrayArray[n2][n] = new ArrayList();
            }
        }
        for (n2 = 0; n2 < sasPlusProblem.numOfOperators; ++n2) {
            for (n = 0; n < sasPlusProblem.addLists[n2].length; ++n) {
                int n3 = sasPlusProblem.addLists[n2][n];
                int n4 = sasPlusProblem.indexToMutexGroup[n3];
                BitSet bitSet = new BitSet();
                int n5 = -1;
                for (int n6 : sasPlusProblem.precLists[n2]) {
                    if (n6 >= sasPlusProblem.firstIndex[n4] && n6 <= sasPlusProblem.lastIndex[n4]) {
                        assert (n5 == -1);
                        n5 = n6;
                        continue;
                    }
                    bitSet.set(n6, true);
                }
                if (n5 > -1) {
                    listArrayArray[n5][n3].add(bitSet);
                    continue;
                }
                for (int i = sasPlusProblem.firstIndex[n4]; i <= sasPlusProblem.lastIndex[n4]; ++i) {
                    if (i == n3) continue;
                    listArrayArray[i][n3].add(bitSet);
                }
            }
        }
        return listArrayArray;
    }

    private int[][] createCG(SasPlusProblem sasPlusProblem, List<BitSet>[][] listArray) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int i = 0; i < sasPlusProblem.numOfVars; ++i) {
            hashSet.add(i);
        }
        return this.createCG(sasPlusProblem, listArray, hashSet);
    }

    private int[][] createCG(SasPlusProblem sasPlusProblem, List<BitSet>[][] listArray, Set<Integer> set) {
        int n;
        int n2;
        int[][] nArrayArray = new int[sasPlusProblem.numOfVars][];
        for (n2 = 0; n2 < sasPlusProblem.numOfVars; ++n2) {
            nArrayArray[n2] = new int[sasPlusProblem.numOfVars];
        }
        for (n2 = 0; n2 < sasPlusProblem.numOfStateFeatures; ++n2) {
            for (int i = 0; i < sasPlusProblem.numOfStateFeatures; ++i) {
                for (BitSet bitSet : listArray[n2][i]) {
                    int n3 = bitSet.nextSetBit(0);
                    while (n3 >= 0) {
                        int n4 = sasPlusProblem.indexToMutexGroup[n2];
                        assert (n4 == sasPlusProblem.indexToMutexGroup[i]);
                        n = sasPlusProblem.indexToMutexGroup[n3];
                        assert (n != n4);
                        assert (n < sasPlusProblem.numOfVars);
                        assert (n4 < sasPlusProblem.numOfVars);
                        if (set.contains(n) && set.contains(n4)) {
                            int[] nArray = nArrayArray[n];
                            int n5 = n4;
                            nArray[n5] = nArray[n5] + 1;
                        }
                        n3 = bitSet.nextSetBit(n3 + 1);
                    }
                }
            }
        }
        for (n2 = 0; n2 < sasPlusProblem.numOfOperators; ++n2) {
            for (int n3 : sasPlusProblem.addLists[n2]) {
                int[] nArray = sasPlusProblem.addLists[n2];
                n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int n6 = sasPlusProblem.indexToMutexGroup[n3];
                    int n7 = nArray[i];
                    int n8 = sasPlusProblem.indexToMutexGroup[n7];
                    if (n6 == n8) continue;
                    assert (n6 < sasPlusProblem.numOfVars);
                    assert (n8 < sasPlusProblem.numOfVars);
                    if (!set.contains(n6) || !set.contains(n8)) continue;
                    int[] nArray2 = nArrayArray[n6];
                    int n9 = n8;
                    nArray2[n9] = nArray2[n9] + 1;
                }
            }
        }
        return nArrayArray;
    }

    private BitSet[] translate(int[][] nArray) {
        BitSet[] bitSetArray = new BitSet[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            bitSetArray[i] = new BitSet();
            for (int j = 0; j < nArray[i].length; ++j) {
                if (nArray[i][j] <= 0) continue;
                bitSetArray[i].set(j);
            }
        }
        return bitSetArray;
    }

    private void pruneGraphs(SasPlusProblem sasPlusProblem, BitSet[] bitSetArray, List<BitSet>[][] listArray) {
        TarjanSCCs tarjanSCCs = new TarjanSCCs(bitSetArray);
        tarjanSCCs.calcSccs();
        int[][] nArray = tarjanSCCs.getSCCs();
        if (tarjanSCCs.biggestScc() > 1) {
            System.out.println("- CG is cyclic, pruning edges to get acyclic");
        }
        for (int[] nArray2 : nArray) {
            int n;
            int n2;
            if (nArray2.length == 1) continue;
            HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
            for (n2 = 0; n2 < nArray2.length; ++n2) {
                n = this.getMinArg(nArray2, listArray, hashMap);
                hashMap.put(n, n2);
            }
            for (n2 = 0; n2 < nArray2.length; ++n2) {
                for (n = 0; n < nArray2.length; ++n) {
                    int n3 = nArray2[n2];
                    int n4 = nArray2[n];
                    if (hashMap.get(n3) > hashMap.get(n4)) {
                        bitSetArray[n3].set(n4, false);
                        continue;
                    }
                    if (hashMap.get(n3) >= hashMap.get(n4)) continue;
                    for (int i = sasPlusProblem.firstIndex[n3]; i <= sasPlusProblem.lastIndex[n3]; ++i) {
                        for (int j = sasPlusProblem.firstIndex[n3]; j <= sasPlusProblem.lastIndex[n3]; ++j) {
                            for (BitSet bitSet : listArray[i][j]) {
                                bitSet.set(sasPlusProblem.firstIndex[n4], sasPlusProblem.lastIndex[n4] + 1, false);
                            }
                        }
                    }
                }
            }
        }
        assert (this.acyclic(bitSetArray));
    }

    /*
     * WARNING - void declaration
     */
    private void pruneDtgs(List<BitSet>[][] listArray) {
        for (int i = 0; i < listArray.length; ++i) {
            for (int j = 0; j < listArray[i].length; ++j) {
                Object object;
                int n;
                void var7_10;
                List<BitSet> list = listArray[i][j];
                if (list.size() < 2) continue;
                HashSet<BitSet> hashSet = new HashSet<BitSet>();
                for (BitSet k : list) {
                    hashSet.add(k);
                }
                list.clear();
                list.addAll(hashSet);
                if (list.size() == 1) continue;
                HashSet hashSet2 = new HashSet();
                boolean bl = false;
                while (var7_10 < list.size()) {
                    for (n = 0; n < list.size(); ++n) {
                        if (var7_10 == n) continue;
                        object = list.get((int)var7_10);
                        BitSet bitSet = list.get(n);
                        BitSet bitSet2 = (BitSet)((BitSet)object).clone();
                        bitSet2.and(bitSet);
                        if (!bitSet2.equals(object)) continue;
                        hashSet2.add(n);
                    }
                    ++var7_10;
                }
                int[] nArray = new int[hashSet2.size()];
                n = 0;
                object = hashSet2.iterator();
                while (object.hasNext()) {
                    int n2 = (Integer)object.next();
                    nArray[n++] = n2;
                }
                Arrays.sort(nArray);
                for (n = nArray.length - 1; n >= 0; --n) {
                    list.remove(nArray[n]);
                }
            }
        }
    }

    private boolean acyclic(BitSet[] bitSetArray) {
        TarjanSCCs tarjanSCCs = new TarjanSCCs(bitSetArray);
        tarjanSCCs.calcSccs();
        return tarjanSCCs.biggestScc() == 1;
    }

    private int getMinArg(int[] nArray, List<BitSet>[][] listArray, HashMap<Integer, Integer> hashMap) {
        int n;
        int n2;
        int n3;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int i = 0; i < nArray.length; ++i) {
            int n4 = nArray[i];
            if (hashMap.containsKey(n4)) continue;
            hashSet.add(n4);
        }
        if (hashSet.size() == 1) {
            return (Integer)hashSet.iterator().next();
        }
        int[][] nArray2 = this.createCG(this.p, listArray, hashSet);
        int[] nArray3 = new int[nArray.length];
        for (n3 = 0; n3 < nArray.length; ++n3) {
            n2 = 0;
            while (n2 < nArray.length) {
                n = nArray[n3];
                int n5 = nArray[n2];
                int n6 = n2++;
                nArray3[n6] = nArray3[n6] + nArray2[n][n5];
            }
        }
        n3 = -1;
        n2 = Integer.MAX_VALUE;
        for (n = 0; n < nArray3.length; ++n) {
            if (hashMap.containsKey(nArray[n]) || nArray3[n] >= n2) continue;
            n3 = n;
            n2 = nArray3[n];
        }
        return nArray[n3];
    }

    private int[][] calcInverseMapping(int[][] nArray) {
        int n;
        int n2;
        List[] listArray = new List[nArray.length];
        for (n2 = 0; n2 < listArray.length; ++n2) {
            listArray[n2] = new ArrayList();
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            for (n = 0; n < nArray[n2].length; ++n) {
                listArray[nArray[n2][n]].add(n2);
            }
        }
        int[][] nArrayArray = new int[listArray.length][];
        for (n = 0; n < listArray.length; ++n) {
            nArrayArray[n] = new int[listArray[n].size()];
            for (int i = 0; i < nArrayArray[n].length; ++i) {
                nArrayArray[n][i] = (Integer)listArray[n].get(i);
            }
        }
        return nArrayArray;
    }

    private BitSet[] createBitMasks(int[][] nArray) {
        BitSet[] bitSetArray = new BitSet[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            bitSetArray[i] = new BitSet();
            for (int n : nArray[i]) {
                bitSetArray[i].set(this.p.firstIndex[n], this.p.lastIndex[n] + 1, true);
            }
        }
        return bitSetArray;
    }

    private int[][] copyToArray(BitSet[] bitSetArray) {
        int[][] nArrayArray = new int[bitSetArray.length][];
        for (int i = 0; i < nArrayArray.length; ++i) {
            nArrayArray[i] = new int[bitSetArray[i].cardinality()];
            int n = 0;
            int n2 = bitSetArray[i].nextSetBit(0);
            while (n2 >= 0) {
                nArrayArray[i][n++] = n2;
                n2 = bitSetArray[i].nextSetBit(n2 + 1);
            }
        }
        return nArrayArray;
    }

    private int[][][][] copyToArray(List<BitSet>[][] listArray) {
        int[][][][] nArrayArray = new int[listArray.length][][][];
        for (int i = 0; i < nArrayArray.length; ++i) {
            nArrayArray[i] = new int[listArray[i].length][][];
            for (int j = 0; j < nArrayArray[i].length; ++j) {
                nArrayArray[i][j] = new int[listArray[i][j].size()][];
                for (int k = 0; k < nArrayArray[i][j].length; ++k) {
                    BitSet bitSet = listArray[i][j].get(k);
                    nArrayArray[i][j][k] = new int[bitSet.cardinality()];
                    int n = 0;
                    int n2 = bitSet.nextSetBit(0);
                    while (n2 >= 0) {
                        nArrayArray[i][j][k][n++] = n2;
                        n2 = bitSet.nextSetBit(n2 + 1);
                    }
                }
            }
        }
        return nArrayArray;
    }

    String dotCg(int[][] nArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("digraph someGraph {\n");
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add("\tnode [label=\"" + this.p.varNames[i] + "\"] node" + i + ";\n");
            for (int j = 0; j < nArray[i].length; ++j) {
                arrayList2.add("\tnode" + i + " -> node" + nArray[i][j] + "\n");
            }
        }
        for (String string2 : arrayList) {
            stringBuilder.append(string2);
        }
        for (String string3 : arrayList2) {
            stringBuilder.append(string3);
        }
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    String dotDtg(int[][][][] nArray, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("digraph someGraph {\n");
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (int i = this.p.firstIndex[n]; i <= this.p.lastIndex[n]; ++i) {
            int n2 = i - this.p.firstIndex[n];
            String string2 = this.p.factStrs[i];
            hashSet.add("\tnode [label=\"" + string2 + "\"] node" + n2 + ";\n");
            for (int j = this.p.firstIndex[n]; j <= this.p.lastIndex[n]; ++j) {
                for (int[] nArray2 : nArray[i][j]) {
                    int n3 = j - this.p.firstIndex[n];
                    String string3 = "";
                    for (int k = 0; k < nArray2.length; ++k) {
                        if (k > 0) {
                            string3 = string3 + ", ";
                        }
                        string3 = string3 + this.p.factStrs[nArray2[k]];
                    }
                    String string4 = "\tnode" + n2 + " -> node" + n3;
                    if (string3.length() > 0) {
                        string4 = string4 + " [label=\"" + string3 + "\"]";
                    }
                    string4 = string4 + "\n";
                    hashSet2.add(string4);
                }
            }
        }
        for (String string5 : hashSet) {
            stringBuilder.append(string5);
        }
        for (String string6 : hashSet2) {
            stringBuilder.append(string6);
        }
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    private void dotIt(SasPlusProblem sasPlusProblem, String string2) {
        try {
            FileWriter fileWriter = new FileWriter(string2 + "cg.dot");
            fileWriter.write(this.dotCg(this.cg));
            fileWriter.close();
            fileWriter = new FileWriter(string2 + "rev.dot");
            fileWriter.write(this.dotCg(this.rev));
            fileWriter.close();
            for (int i = 0; i < sasPlusProblem.numOfVars; ++i) {
                fileWriter = new FileWriter(string2 + "var" + i + ".dot");
                fileWriter.write(this.dotDtg(this.dtgs, i));
                fileWriter.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

