/*
 * Decompiled with CFR 0.152.
 */
package de.uniulm.ki.panda3.progression.htn.representation;

import de.uniulm.ki.panda3.progression.htn.representation.ProSubtaskNetwork;
import de.uniulm.ki.panda3.progression.htn.search.ProgressionNetwork;
import de.uniulm.ki.panda3.progression.htn.search.ProgressionPlanStep;
import de.uniulm.ki.panda3.symbolic.domain.SimpleDecompositionMethod;
import de.uniulm.ki.panda3.symbolic.domain.Task;
import de.uniulm.ki.panda3.symbolic.plan.element.OrderingConstraint;
import de.uniulm.ki.panda3.symbolic.plan.element.PlanStep;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import scala.collection.Seq;

public class ProMethod {
    public int methodID;
    public final SimpleDecompositionMethod m;
    public Task[] subtasks;
    public int numDistinctSubTasks = 0;
    int[] actionID;
    List<ProMethod>[] methods;
    List<int[]> orderings;
    HashSet<Integer> firsts;
    HashSet<Integer> lasts;
    public int numberOfPrimSubtasks = 0;
    public int numberOfAbsSubtasks;

    public ProMethod(SimpleDecompositionMethod simpleDecompositionMethod) {
        int n;
        this.m = simpleDecompositionMethod;
        Seq<PlanStep> seq = simpleDecompositionMethod.subPlan().planStepsWithoutInitGoal();
        this.subtasks = new Task[seq.size()];
        this.actionID = new int[seq.size()];
        this.methods = new List[seq.size()];
        for (int i = 0; i < seq.size(); ++i) {
            this.subtasks[i] = ((PlanStep)seq.apply(i)).schema();
            if (!this.subtasks[i].isPrimitive()) continue;
            ++this.numberOfPrimSubtasks;
        }
        this.numberOfAbsSubtasks = seq.size() - this.numberOfPrimSubtasks;
        this.orderings = new ArrayList<int[]>();
        Seq<OrderingConstraint> seq2 = simpleDecompositionMethod.subPlan().orderingConstraints().minimalOrderingConstraints();
        for (n = 0; n < seq2.size(); ++n) {
            OrderingConstraint object = (OrderingConstraint)seq2.apply(n);
            int n2 = seq.indexOf(object.before());
            int n3 = seq.indexOf(object.after());
            if (n2 == -1 || n3 == -1) continue;
            int[] nArray = new int[]{n2, n3};
            this.orderings.add(nArray);
        }
        this.firsts = new HashSet();
        this.lasts = new HashSet();
        for (n = 0; n < this.subtasks.length; ++n) {
            this.firsts.add(n);
            this.lasts.add(n);
        }
        for (int[] nArray : this.orderings) {
            this.firsts.remove(nArray[1]);
            this.lasts.remove(nArray[0]);
        }
    }

    public void finalizeMethod(HashMap<Task, List<ProMethod>> hashMap) {
        HashSet<Task> hashSet = new HashSet<Task>();
        for (Task task : this.subtasks) {
            hashSet.add(task);
        }
        this.numDistinctSubTasks = hashSet.size();
        for (int i = 0; i < this.subtasks.length; ++i) {
            if (this.subtasks[i].isPrimitive()) {
                this.actionID[i] = ProgressionNetwork.taskToIndex.get(this.subtasks[i]);
                continue;
            }
            this.methods[i] = hashMap.get(this.subtasks[i]);
            assert (this.methods[i] != null);
            assert (this.methods[i].size() > 0);
            this.actionID[i] = -1;
        }
    }

    public ProSubtaskNetwork instantiate() {
        ProgressionPlanStep[] progressionPlanStepArray = new ProgressionPlanStep[this.subtasks.length];
        for (int i = 0; i < progressionPlanStepArray.length; ++i) {
            progressionPlanStepArray[i] = new ProgressionPlanStep(this.subtasks[i]);
            progressionPlanStepArray[i].action = this.actionID[i];
            progressionPlanStepArray[i].methods = this.methods[i];
        }
        for (int[] object2 : this.orderings) {
            progressionPlanStepArray[object2[0]].successorList.add(progressionPlanStepArray[object2[1]]);
        }
        LinkedList linkedList = new LinkedList();
        for (Object object : this.firsts) {
            linkedList.add(progressionPlanStepArray[(Integer)object]);
        }
        LinkedList<ProgressionPlanStep> linkedList2 = new LinkedList<ProgressionPlanStep>();
        for (Integer n : this.lasts) {
            linkedList2.add(progressionPlanStepArray[n]);
        }
        return new ProSubtaskNetwork(progressionPlanStepArray, linkedList, linkedList2);
    }

    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("task ");
        stringBuilder.append(this.m.abstractTask().longInfo());
        stringBuilder.append("\n t { 0: ");
        if (this.subtasks.length > 0) {
            stringBuilder.append(this.subtasks[0].longInfo());
        }
        for (n = 1; n < this.subtasks.length; ++n) {
            stringBuilder.append("\n     ");
            stringBuilder.append(n);
            stringBuilder.append(": ");
            stringBuilder.append(this.subtasks[n].longInfo());
        }
        stringBuilder.append("}\n < { ");
        if (this.orderings.size() > 0) {
            int[] nArray = this.orderings.get(0);
            stringBuilder.append(nArray[0]);
            stringBuilder.append("<");
            stringBuilder.append(nArray[1]);
        }
        for (n = 1; n < this.orderings.size(); ++n) {
            int[] nArray = this.orderings.get(n);
            stringBuilder.append(", ");
            stringBuilder.append(nArray[0]);
            stringBuilder.append("<");
            stringBuilder.append(nArray[1]);
        }
        stringBuilder.append(" }\n");
        return stringBuilder.toString();
    }
}

