/*
 * Decompiled with CFR 0.152.
 */
package de.uniulm.ki.panda3.progression.htn.representation;

import de.uniulm.ki.panda3.symbolic.domain.Task;
import java.io.BufferedReader;
import java.io.FileReader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import scala.Tuple2;

public class SasPlusProblem {
    private static String noVal = "<none of those>";
    private static String negation = "not->";
    private int version;
    private int error = 0;
    private boolean actionCosts = false;
    public int numOfVars;
    private int numOfMutexGroups;
    private int numOfGoalPairs;
    public int numOfOperators;
    private int[] axioms;
    public int[] ranges;
    public String[] varNames;
    public String[][] values;
    private int[] s0;
    private int[][] goal;
    public String[] opNames;
    private int[] numPrevailConditions;
    private int[][][] prevailConditions;
    private int[][] numOfEffectConditions;
    private int[][][] effectConditions;
    private int[] numEffects;
    private int[][] effectVar;
    private int[][] effectVarPrec;
    private int[][] effectVarEff;
    public int[] costs;
    public int numOfStateFeatures;
    public int[] firstIndex;
    public int[] lastIndex;
    public int[] indexToMutexGroup;
    public int[][] precLists;
    public int[][] addLists;
    public int[][] delLists;
    public int[][] expandedDelLists;
    public int[][] precToTask;
    public int[][] addToTask;
    public int[] numPrecs;
    public int[] s0List;
    private BitSet s0Bitset = null;
    public int[] gList;
    public String[] factStrs;
    DecimalFormat f = new DecimalFormat("#0.00");

    public BitSet getS0() {
        if (this.s0Bitset == null) {
            this.s0Bitset = new BitSet(this.numOfStateFeatures);
            for (int n : this.s0List) {
                this.s0Bitset.set(n);
            }
        }
        return this.s0Bitset;
    }

    public String factName(int n) {
        return this.factStrs[n];
    }

    public String printOp(int n) {
        String string2 = "";
        string2 = string2 + this.opNames[n];
        string2 = string2 + this.printFactList(this.precLists[n]);
        string2 = string2 + this.printFactList(this.addLists[n]);
        string2 = string2 + this.printFactList(this.delLists[n]);
        return string2;
    }

    private String printFactList(int[] nArray) {
        String string2 = "{";
        for (int i = 0; i < nArray.length; ++i) {
            if (i > 0) {
                string2 = string2 + ", ";
            }
            string2 = string2 + this.factName(nArray[i]);
        }
        return string2 + "}";
    }

    public void prepareEfficientRep() {
        int n;
        this.numOfStateFeatures = 0;
        this.firstIndex = new int[this.numOfVars];
        this.lastIndex = new int[this.numOfVars];
        for (n = 0; n < this.numOfVars; ++n) {
            this.firstIndex[n] = this.numOfStateFeatures;
            this.numOfStateFeatures += this.ranges[n];
            this.lastIndex[n] = this.numOfStateFeatures - 1;
        }
        this.indexToMutexGroup = new int[this.numOfStateFeatures];
        for (n = 0; n < this.numOfVars; ++n) {
            for (int i = this.firstIndex[n]; i <= this.lastIndex[n]; ++i) {
                this.indexToMutexGroup[i] = n;
            }
        }
        this.precLists = new int[this.numOfOperators][];
        this.addLists = new int[this.numOfOperators][];
        this.delLists = new int[this.numOfOperators][];
        this.expandedDelLists = new int[this.numOfOperators][];
        this.numPrecs = new int[this.numOfOperators];
        for (n = 0; n < this.numOfOperators; ++n) {
            int n2;
            int n3;
            int n4;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
            for (n4 = 0; n4 < this.numPrevailConditions[n]; ++n4) {
                n3 = this.prevailConditions[n][n4][0];
                n2 = this.prevailConditions[n][n4][1];
                arrayList.add(this.firstIndex[n3] + n2);
            }
            for (n4 = 0; n4 < this.numEffects[n]; ++n4) {
                n3 = this.effectVar[n][n4];
                n2 = this.effectVarPrec[n][n4];
                int n5 = this.effectVarEff[n][n4];
                if (n2 > -1) {
                    arrayList.add(this.firstIndex[n3] + n2);
                    arrayList3.add(this.firstIndex[n3] + n2);
                } else {
                    int n6 = this.firstIndex[n3] + n5;
                    for (int i = this.firstIndex[n3]; i <= this.lastIndex[n3]; ++i) {
                        if (i == n6) continue;
                        arrayList3.add(i);
                    }
                }
                arrayList2.add(this.firstIndex[n3] + n5);
                if (this.numOfEffectConditions[n][n4] <= 0) continue;
                this.error = 1;
                System.out.println("Error: (SAS+ parser) Found conditional effects - this feature is not (yet) supported.");
            }
            this.numPrecs[n] = arrayList.size();
            this.precLists[n] = new int[arrayList.size()];
            this.addLists[n] = new int[arrayList2.size()];
            this.delLists[n] = new int[arrayList3.size()];
            for (n4 = 0; n4 < arrayList.size(); ++n4) {
                this.precLists[n][n4] = (Integer)arrayList.get(n4);
            }
            for (n4 = 0; n4 < arrayList2.size(); ++n4) {
                this.addLists[n][n4] = (Integer)arrayList2.get(n4);
            }
            for (n4 = 0; n4 < arrayList3.size(); ++n4) {
                this.delLists[n][n4] = (Integer)arrayList3.get(n4);
            }
        }
        this.calcInverseMappings();
        this.calcExtendedDelLists();
        this.s0List = new int[this.numOfVars];
        for (n = 0; n < this.numOfVars; ++n) {
            this.s0List[n] = this.firstIndex[n] + this.s0[n];
        }
        this.gList = new int[this.goal.length];
        for (n = 0; n < this.goal.length; ++n) {
            this.gList[n] = this.firstIndex[this.goal[n][0]] + this.goal[n][1];
        }
        this.factStrs = new String[this.numOfStateFeatures];
        n = 0;
        for (int i = 0; i < this.values.length; ++i) {
            for (int j = 0; j < this.values[i].length; ++j) {
                this.factStrs[n++] = this.varNames[i] + "=" + this.values[i][j];
            }
        }
    }

    public SasPlusProblem() {
    }

    public SasPlusProblem(String string2) throws Exception {
        int n;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string2));
        String string3 = bufferedReader.readLine();
        if (!string3.equals("begin_version")) {
            this.error = 1;
            System.out.println("Error: (SAS+ parser) Did not find version element.");
            return;
        }
        this.readVersion(bufferedReader);
        string3 = bufferedReader.readLine();
        if (!string3.equals("begin_metric")) {
            this.error = 1;
            System.out.println("Error: (SAS+ parser) Did not find metric element.");
            return;
        }
        this.readMetric(bufferedReader);
        this.numOfVars = Integer.parseInt(bufferedReader.readLine());
        this.varNames = new String[this.numOfVars];
        this.axioms = new int[this.numOfVars];
        this.ranges = new int[this.numOfVars];
        this.values = new String[this.numOfVars][];
        for (n = 0; n < this.numOfVars; ++n) {
            this.readVariable(bufferedReader, n);
        }
        this.numOfMutexGroups = Integer.parseInt(bufferedReader.readLine());
        for (n = 0; n < this.numOfMutexGroups; ++n) {
            this.readMutex(bufferedReader, n);
        }
        string3 = bufferedReader.readLine();
        if (!string3.equals("begin_state")) {
            this.error = 1;
            System.out.println("Error: (SAS+ parser) Did not find (initial) state element.");
            return;
        }
        this.readS0(bufferedReader);
        string3 = bufferedReader.readLine();
        if (!string3.equals("begin_goal")) {
            this.error = 1;
            System.out.println("Error: (SAS+ parser) Did not find goal element.");
            return;
        }
        this.readGoal(bufferedReader);
        string3 = bufferedReader.readLine();
        this.numOfOperators = Integer.parseInt(bufferedReader.readLine());
        this.opNames = new String[this.numOfOperators];
        this.numEffects = new int[this.numOfOperators];
        this.numPrevailConditions = new int[this.numOfOperators];
        this.prevailConditions = new int[this.numOfOperators][][];
        this.numOfEffectConditions = new int[this.numOfOperators][];
        this.effectConditions = new int[this.numOfOperators][][];
        this.effectVar = new int[this.numOfOperators][];
        this.effectVarPrec = new int[this.numOfOperators][];
        this.effectVarEff = new int[this.numOfOperators][];
        this.costs = new int[this.numOfOperators];
        for (n = 0; n < this.numOfOperators; ++n) {
            this.readOperator(bufferedReader, n);
        }
    }

    private void readOperator(BufferedReader bufferedReader, int n) throws Exception {
        String[] stringArray;
        int n2;
        if (!bufferedReader.readLine().equals("begin_operator")) {
            this.error = 1;
            System.out.println("Error: (SAS+ parser) Unexpected structure of operator element.");
        }
        this.opNames[n] = bufferedReader.readLine();
        this.numPrevailConditions[n] = Integer.parseInt(bufferedReader.readLine());
        this.prevailConditions[n] = new int[this.numPrevailConditions[n]][];
        for (n2 = 0; n2 < this.numPrevailConditions[n]; ++n2) {
            this.prevailConditions[n][n2] = new int[2];
            stringArray = bufferedReader.readLine().split(" ");
            this.prevailConditions[n][n2][0] = Integer.parseInt(stringArray[0]);
            this.prevailConditions[n][n2][1] = Integer.parseInt(stringArray[1]);
        }
        this.numEffects[n] = Integer.parseInt(bufferedReader.readLine());
        this.numOfEffectConditions[n] = new int[this.numEffects[n]];
        this.effectVar[n] = new int[this.numEffects[n]];
        this.effectVarPrec[n] = new int[this.numEffects[n]];
        this.effectVarEff[n] = new int[this.numEffects[n]];
        for (n2 = 0; n2 < this.numEffects[n]; ++n2) {
            stringArray = bufferedReader.readLine().split(" ");
            int n3 = 0;
            this.numOfEffectConditions[n][n2] = Integer.parseInt(stringArray[n3++]);
            for (int i = 0; i < this.numOfEffectConditions[n][n2]; ++i) {
                this.effectConditions[n][n2] = new int[2];
                this.effectConditions[n][n2][0] = Integer.parseInt(stringArray[n3++]);
                this.effectConditions[n][n2][1] = Integer.parseInt(stringArray[n3++]);
            }
            this.effectVar[n][n2] = Integer.parseInt(stringArray[n3++]);
            this.effectVarPrec[n][n2] = Integer.parseInt(stringArray[n3++]);
            this.effectVarEff[n][n2] = Integer.parseInt(stringArray[n3++]);
        }
        this.costs[n] = Integer.parseInt(bufferedReader.readLine());
        if (!bufferedReader.readLine().equals("end_operator")) {
            this.error = 1;
            System.out.println("Error: (SAS+ parser) Unexpected structure of operator element.");
        }
    }

    private void readGoal(BufferedReader bufferedReader) throws Exception {
        this.numOfGoalPairs = Integer.parseInt(bufferedReader.readLine());
        this.goal = new int[this.numOfGoalPairs][];
        for (int i = 0; i < this.numOfGoalPairs; ++i) {
            String[] stringArray = bufferedReader.readLine().trim().split(" ");
            this.goal[i] = new int[2];
            this.goal[i][0] = Integer.parseInt(stringArray[0]);
            this.goal[i][1] = Integer.parseInt(stringArray[1]);
        }
    }

    private void readS0(BufferedReader bufferedReader) throws Exception {
        this.s0 = new int[this.numOfVars];
        for (int i = 0; i < this.numOfVars; ++i) {
            this.s0[i] = Integer.parseInt(bufferedReader.readLine());
        }
        if (!bufferedReader.readLine().equals("end_state")) {
            this.error = 1;
            System.out.println("Error: (SAS+ parser) Unexpected structure of (initial) state element.");
        }
    }

    private void readMutex(BufferedReader bufferedReader, int n) throws Exception {
        while (!bufferedReader.readLine().equals("end_mutex_group")) {
        }
    }

    private void readVariable(BufferedReader bufferedReader, int n) throws Exception {
        if (!bufferedReader.readLine().equals("begin_variable")) {
            this.error = 1;
            System.out.println("Error: (SAS+ parser) Unexpected structure of variable element.");
        }
        this.varNames[n] = bufferedReader.readLine();
        this.axioms[n] = Integer.parseInt(bufferedReader.readLine());
        this.ranges[n] = Integer.parseInt(bufferedReader.readLine());
        this.values[n] = new String[this.ranges[n]];
        for (int i = 0; i < this.ranges[n]; ++i) {
            String string2 = bufferedReader.readLine();
            if (string2.equals(noVal)) {
                this.values[n][i] = string2;
                continue;
            }
            if (string2.startsWith("Atom ")) {
                this.values[n][i] = string2.substring("Atom ".length(), string2.length());
                continue;
            }
            if (string2.startsWith("NegatedAtom ")) {
                this.values[n][i] = negation + string2.substring("NegatedAtom ".length(), string2.length());
                continue;
            }
            this.values[n][i] = string2;
            this.error = 1;
            System.out.println("Error: (SAS+ parser) Unexpected structure of variable element.");
        }
        if (!bufferedReader.readLine().equals("end_variable")) {
            this.error = 1;
            System.out.println("Error: (SAS+ parser) Unexpected structure of variable element.");
        }
    }

    private void readMetric(BufferedReader bufferedReader) throws Exception {
        String string2 = bufferedReader.readLine();
        int n = Integer.parseInt(string2);
        if (n == 1) {
            this.actionCosts = true;
        }
        if (n < 0 || n > 1 || !bufferedReader.readLine().equals("end_metric")) {
            this.error = 1;
            System.out.println("Error: (SAS+ parser) Unexpected structure of metric element.");
        }
    }

    private void readVersion(BufferedReader bufferedReader) throws Exception {
        String string2 = bufferedReader.readLine();
        this.version = Integer.parseInt(string2);
        if (!bufferedReader.readLine().equals("end_version")) {
            this.error = 1;
            System.out.println("Error: (SAS+ parser) Unexpected structure of version element.");
        }
    }

    public String toString() {
        String string2 = "";
        for (int i = 0; i < this.numOfOperators; ++i) {
            String string3 = this.opNames[i] + "\n\tp{";
            string3 = string3 + this.listToString(this.precLists[i]) + "}\n\ta{";
            string3 = string3 + this.listToString(this.addLists[i]) + "}\n\td{";
            string3 = string3 + this.listToString(this.delLists[i]) + "}";
            string2 = string2 + string3 + "\n";
        }
        return string2;
    }

    private String listToString(int[] nArray) {
        String string2 = "";
        for (int i = 0; i < nArray.length; ++i) {
            if (i > 0) {
                string2 = string2 + ", ";
            }
            string2 = string2 + this.factStrs[nArray[i]];
        }
        return string2;
    }

    public String orgSasToString() {
        int n;
        int n2;
        StringBuilder stringBuilder = new StringBuilder("");
        stringBuilder.append("Version: ");
        stringBuilder.append(this.version);
        stringBuilder.append("\n\nMetric: ");
        if (!this.actionCosts) {
            stringBuilder.append("no ");
        }
        stringBuilder.append("action costs\n\n");
        for (n2 = 0; n2 < this.numOfVars; ++n2) {
            stringBuilder.append(this.varNames[n2]);
            stringBuilder.append(" {");
            for (n = 0; n < this.ranges[n2]; ++n) {
                if (n > 0) {
                    stringBuilder.append("; ");
                }
                stringBuilder.append(this.values[n2][n]);
            }
            stringBuilder.append("}\n\n");
        }
        stringBuilder.append("Skipped mutex groups\n\n");
        stringBuilder.append("s0 {");
        for (n2 = 0; n2 < this.numOfVars; ++n2) {
            if (n2 > 0) {
                stringBuilder.append("; ");
            }
            stringBuilder.append(this.varNames[n2]);
            stringBuilder.append("=");
            stringBuilder.append(this.values[n2][this.s0[n2]]);
        }
        stringBuilder.append("}\n\n");
        stringBuilder.append("g {");
        for (n2 = 0; n2 < this.numOfGoalPairs; ++n2) {
            if (n2 > 0) {
                stringBuilder.append("; ");
            }
            stringBuilder.append(this.varNames[this.goal[n2][0]]);
            stringBuilder.append("=");
            stringBuilder.append(this.values[this.goal[n2][0]][this.goal[n2][1]]);
        }
        stringBuilder.append("}\n\n");
        for (n2 = 0; n2 < this.numOfOperators; ++n2) {
            stringBuilder.append(this.opNames[n2]);
            stringBuilder.append(" {\n");
            stringBuilder.append("Prevail-Cond: {");
            for (n = 0; n < this.numPrevailConditions[n2]; ++n) {
                if (n > 0) {
                    stringBuilder.append("; ");
                }
                stringBuilder.append(this.varNames[this.prevailConditions[n2][n][0]]);
                stringBuilder.append("=");
                stringBuilder.append(this.values[this.prevailConditions[n2][n][0]][this.prevailConditions[n2][n][1]]);
            }
            stringBuilder.append("}\n");
            stringBuilder.append("Precs:        {");
            for (n = 0; n < this.numEffects[n2]; ++n) {
                if (n > 0) {
                    stringBuilder.append("; ");
                }
                stringBuilder.append(this.varNames[this.effectVar[n2][n]]);
                stringBuilder.append("=");
                if (this.effectVarPrec[n2][n] != -1) {
                    stringBuilder.append(this.values[this.effectVar[n2][n]][this.effectVarPrec[n2][n]]);
                    continue;
                }
                stringBuilder.append("none-of-them");
            }
            stringBuilder.append("}\n");
            stringBuilder.append("Effects:      {");
            for (n = 0; n < this.numEffects[n2]; ++n) {
                if (n > 0) {
                    stringBuilder.append("; ");
                }
                stringBuilder.append(this.varNames[this.effectVar[n2][n]]);
                stringBuilder.append("=");
                stringBuilder.append(this.values[this.effectVar[n2][n]][this.effectVarEff[n2][n]]);
            }
            stringBuilder.append("}\n");
            stringBuilder.append("Costs:        ");
            stringBuilder.append(this.costs[n2]);
            stringBuilder.append("\n");
            stringBuilder.append("}\n\n");
        }
        return stringBuilder.toString();
    }

    public String[] getGroundedOperatorSignatures() {
        return this.opNames;
    }

    private int[] delete(int[] nArray, int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < nArray.length; ++i) {
            if (this.indexToMutexGroup[nArray[i]] == n) continue;
            arrayList.add(nArray[i]);
        }
        int[] nArray2 = new int[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            nArray2[i] = (Integer)arrayList.get(i);
        }
        return nArray2;
    }

    public Tuple2<Map<Integer, Task>, Map<Task, Integer>> restrictTo(Set<Integer> set, Map<Integer, Task> map2) {
        int n;
        int n2;
        assert (this.correctModel());
        int n3 = set.size();
        System.out.print("Reducing SAS+ domain ... ");
        int n4 = this.numOfOperators;
        int n5 = this.numOfStateFeatures;
        int n6 = -1;
        for (n2 = 0; n2 < this.numOfVars; ++n2) {
            if (this.ranges[n2] != 2 || !this.factStrs[this.firstIndex[n2]].contains("__goal()")) continue;
            n6 = n2;
        }
        if (n6 >= 0) {
            for (n2 = 0; n2 < this.numOfOperators; ++n2) {
                this.precLists[n2] = this.delete(this.precLists[n2], n6);
                this.addLists[n2] = this.delete(this.addLists[n2], n6);
                this.delLists[n2] = this.delete(this.delLists[n2], n6);
            }
            this.s0List = this.delete(this.s0List, n6);
            this.gList = this.delete(this.gList, n6);
        }
        int[] nArray = new int[n3];
        HashMap<Task, Integer> hashMap = new HashMap<Task, Integer>();
        HashMap<Integer, Task> hashMap2 = new HashMap<Integer, Task>();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        Iterator<Integer> iterator2 = set.iterator();
        int n7 = 0;
        while (iterator2.hasNext()) {
            int n8;
            nArray[n7] = n8 = iterator2.next().intValue();
            for (int n9 : this.precLists[n8]) {
                hashSet.add(n9);
            }
            for (int n9 : this.addLists[n8]) {
                hashSet.add(n9);
            }
            for (int n9 : this.delLists[n8]) {
                hashSet.add(n9);
            }
            hashMap2.put(n7, map2.get(n8));
            hashMap.put(map2.get(n8), n7);
            ++n7;
        }
        Iterator iterator3 = hashSet.iterator();
        int[] nArray2 = new int[hashSet.size()];
        for (int i = 0; i < hashSet.size(); ++i) {
            nArray2[i] = (Integer)iterator3.next();
        }
        Arrays.sort(nArray2);
        int[] nArray3 = new int[hashSet.size()];
        int[] nArray4 = new int[this.numOfStateFeatures];
        int[] nArray5 = new int[hashSet.size()];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray4[nArray2[i]] = i;
            nArray5[i] = nArray2[i];
            nArray3[i] = this.indexToMutexGroup[nArray2[i]];
        }
        int[][] nArrayArray = new int[n3][];
        int[][] nArrayArray2 = new int[n3][];
        int[][] nArrayArray3 = new int[n3][];
        int[] nArray6 = new int[n3];
        int[] nArray7 = new int[n3];
        for (int i = 0; i < nArray.length; ++i) {
            int n10;
            int[] nArray8 = this.precLists[nArray[i]];
            int[] nArray9 = this.addLists[nArray[i]];
            int[] nArray10 = this.delLists[nArray[i]];
            int[] nArray11 = new int[nArray8.length];
            int[] nArray12 = new int[nArray9.length];
            int[] nArray13 = new int[nArray10.length];
            for (n10 = 0; n10 < nArray8.length; ++n10) {
                nArray11[n10] = nArray4[nArray8[n10]];
            }
            for (n10 = 0; n10 < nArray9.length; ++n10) {
                nArray12[n10] = nArray4[nArray9[n10]];
            }
            for (n10 = 0; n10 < nArray10.length; ++n10) {
                nArray13[n10] = nArray4[nArray10[n10]];
            }
            nArray6[i] = this.numPrecs[nArray[i]];
            nArray7[i] = this.costs[nArray[i]];
            nArrayArray[i] = nArray11;
            nArrayArray2[i] = nArray12;
            nArrayArray3[i] = nArray13;
        }
        this.numPrecs = nArray6;
        this.costs = nArray7;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this.s0List.length; ++i) {
            if (!hashSet.contains(this.s0List[i])) continue;
            arrayList.add(nArray4[this.s0List[i]]);
        }
        int[] nArray14 = new int[arrayList.size()];
        for (n = 0; n < nArray14.length; ++n) {
            nArray14[n] = (Integer)arrayList.get(n);
        }
        arrayList.clear();
        for (n = 0; n < this.gList.length; ++n) {
            if (!hashSet.contains(this.gList[n])) continue;
            arrayList.add(nArray4[this.gList[n]]);
        }
        int[] nArray15 = new int[arrayList.size()];
        for (int i = 0; i < nArray15.length; ++i) {
            nArray15[i] = (Integer)arrayList.get(i);
        }
        this.numOfStateFeatures = hashSet.size();
        this.numOfOperators = n3;
        this.indexToMutexGroup = nArray3;
        this.calcMutexGroupIndices();
        this.calcRanges();
        this.numOfVars = this.firstIndex.length;
        this.precLists = nArrayArray;
        this.addLists = nArrayArray2;
        this.delLists = nArrayArray3;
        this.calcInverseMappings();
        this.calcExtendedDelLists();
        String[] stringArray = new String[this.numOfStateFeatures];
        for (int i = 0; i < this.numOfStateFeatures; ++i) {
            stringArray[i] = this.factStrs[nArray5[i]];
        }
        this.factStrs = stringArray;
        String[] stringArray2 = new String[this.numOfOperators];
        for (int i = 0; i < this.numOfOperators; ++i) {
            stringArray2[i] = this.opNames[nArray[i]];
        }
        this.opNames = stringArray2;
        this.s0List = nArray14;
        this.gList = nArray15;
        this.s0Bitset = null;
        System.out.println("done.");
        System.out.println(" - Reduced number of operators from " + n4 + " to " + set.size());
        System.out.println(" - Reduced number of state-bits from " + n5 + " to " + hashSet.size());
        assert (this.correctModel());
        return new Tuple2<Map<Integer, Task>, Map<Task, Integer>>(hashMap2, hashMap);
    }

    public void calcMutexGroupIndices() {
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        int n2 = -1;
        int n3 = -1;
        for (n = 0; n < this.indexToMutexGroup.length; ++n) {
            if (this.indexToMutexGroup[n] != n2) {
                arrayList.add(n);
                if (n2 >= 0) {
                    arrayList2.add(n - 1);
                }
                n2 = this.indexToMutexGroup[n];
            }
            this.indexToMutexGroup[n] = ++n3;
        }
        arrayList2.add(this.indexToMutexGroup.length - 1);
        this.firstIndex = new int[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            this.firstIndex[n] = (Integer)arrayList.get(n);
        }
        this.lastIndex = new int[arrayList2.size()];
        for (n = 0; n < arrayList2.size(); ++n) {
            this.lastIndex[n] = (Integer)arrayList2.get(n);
        }
        this.numOfVars = this.firstIndex.length;
        assert (this.firstIndex.length == this.lastIndex.length);
    }

    public void calcRanges() {
        this.ranges = new int[this.firstIndex.length];
        for (int i = 0; i < this.firstIndex.length; ++i) {
            this.ranges[i] = this.lastIndex[i] - this.firstIndex[i] + 1;
        }
    }

    public void calcExtendedDelLists() {
        List<Integer> list;
        int n;
        List[] listArray = new List[this.numOfOperators];
        for (n = 0; n < this.numOfOperators; ++n) {
            list = new ArrayList();
            listArray[n] = list;
            for (int n2 : this.delLists[n]) {
                list.add(n2);
            }
            for (int n2 : this.addLists[n]) {
                int n3 = this.indexToMutexGroup[n2];
                for (int i = this.firstIndex[n3]; i <= this.lastIndex[n3]; ++i) {
                    if (i == n2) continue;
                    list.add(i);
                }
            }
        }
        this.expandedDelLists = new int[this.numOfOperators][];
        for (n = 0; n < this.numOfOperators; ++n) {
            list = listArray[n];
            this.expandedDelLists[n] = new int[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                this.expandedDelLists[n][i] = (Integer)list.get(i);
            }
        }
    }

    public void calcInverseMappings() {
        int n;
        Object object;
        int n2;
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        for (n2 = 0; n2 < this.numOfStateFeatures; ++n2) {
            hashMap.put(n2, new HashSet());
            hashMap2.put(n2, new HashSet());
        }
        for (n2 = 0; n2 < this.numOfOperators; ++n2) {
            for (Object object2 : this.precLists[n2]) {
                ((Set)hashMap.get(object2)).add(n2);
            }
            object = this.addLists[n2];
            int n3 = ((int[])object).length;
            for (n = 0; n < n3; ++n) {
                Object object2;
                object2 = object[n];
                ((Set)hashMap2.get(object2)).add(n2);
            }
        }
        this.precToTask = new int[this.numOfStateFeatures][];
        for (n2 = 0; n2 < this.numOfStateFeatures; ++n2) {
            object = (Set)hashMap.get(n2);
            this.precToTask[n2] = new int[object.size()];
            Iterator iterator2 = object.iterator();
            for (n = 0; n < object.size(); ++n) {
                this.precToTask[n2][n] = (Integer)iterator2.next();
            }
        }
        this.addToTask = new int[this.numOfStateFeatures][];
        for (n2 = 0; n2 < this.numOfStateFeatures; ++n2) {
            object = (Set)hashMap2.get(n2);
            this.addToTask[n2] = new int[object.size()];
            Iterator iterator3 = object.iterator();
            for (n = 0; n < object.size(); ++n) {
                this.addToTask[n2][n] = (Integer)iterator3.next();
            }
        }
    }

    public void removeDublicates(boolean bl) {
        this.removeDublicates(this.precLists, true, bl);
        this.removeDublicates(this.addLists, false, bl);
        this.removeDublicates(this.delLists, false, bl);
    }

    private void removeDublicates(int[][] nArray, boolean bl, boolean bl2) {
        for (int i = 0; i < nArray.length; ++i) {
            int n;
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (n = 0; n < nArray[i].length; ++n) {
                if (bl2 && hashSet.contains(nArray[i][n])) {
                    System.out.println("The operator " + this.opNames[i] + " has duplicates in its prec/add/del lists. These will be removed.");
                }
                hashSet.add(nArray[i][n]);
            }
            if (hashSet.size() >= nArray[i].length) continue;
            if (bl) {
                this.numPrecs[i] = hashSet.size();
            }
            nArray[i] = new int[hashSet.size()];
            n = 0;
            Iterator iterator2 = hashSet.iterator();
            while (iterator2.hasNext()) {
                int n2 = (Integer)iterator2.next();
                nArray[i][n++] = n2;
            }
        }
    }

    public boolean correctModel() {
        return this.correctModel(false);
    }

    public boolean correctModel(boolean bl) {
        int n5;
        int n2;
        int[] nArray;
        int n32;
        int n4;
        assert (this.precLists.length == this.numOfOperators);
        assert (this.addLists.length == this.numOfOperators);
        assert (this.delLists.length == this.numOfOperators);
        assert (this.expandedDelLists.length == this.numOfOperators);
        for (n4 = 0; n4 < this.numOfOperators; ++n4) {
            for (int n32 : this.precLists[n4]) {
                assert (n32 < this.numOfStateFeatures);
                assert (this.aContains(this.precToTask[n32], n4));
            }
            for (int n32 : this.addLists[n4]) {
                assert (n32 < this.numOfStateFeatures);
                assert (this.aContains(this.addToTask[n32], n4));
            }
            for (int n32 : this.delLists[n4]) {
                assert (n32 < this.numOfStateFeatures);
            }
            nArray = this.expandedDelLists[n4];
            n2 = nArray.length;
            for (n5 = 0; n5 < n2; ++n5) {
                n32 = nArray[n5];
                assert (n32 < this.numOfStateFeatures);
            }
        }
        assert (this.addToTask.length == this.numOfStateFeatures);
        assert (this.precToTask.length == this.numOfStateFeatures);
        for (n4 = 0; n4 < this.numOfStateFeatures; ++n4) {
            for (int n32 : this.precToTask[n4]) {
                assert (n32 < this.numOfOperators);
                assert (this.aContains(this.precLists[n32], n4));
            }
            nArray = this.addToTask[n4];
            n2 = nArray.length;
            for (n5 = 0; n5 < n2; ++n5) {
                n32 = nArray[n5];
                assert (n32 < this.numOfOperators);
                assert (this.aContains(this.addLists[n32], n4));
            }
        }
        for (int n5 : this.s0List) {
            assert (n5 < this.numOfStateFeatures);
        }
        for (int n5 : this.gList) {
            assert (n5 < this.numOfStateFeatures);
        }
        assert (this.indexToMutexGroup.length == this.numOfStateFeatures);
        assert (this.costs.length == this.numOfOperators);
        assert (this.opNames.length == this.numOfOperators);
        assert (this.factStrs.length == this.numOfStateFeatures);
        assert (this.indexToMutexGroup[this.numOfStateFeatures - 1] == this.firstIndex.length - 1);
        assert (this.firstIndex.length == this.lastIndex.length);
        assert (this.numOfVars == this.ranges.length);
        assert (this.firstIndex.length == this.ranges.length);
        if (!bl) {
            for (int i = 0; i < this.numOfVars; ++i) {
                int n6 = this.getS0().nextSetBit(this.firstIndex[i]);
                assert (n6 >= 0);
                assert (n6 <= this.lastIndex[i]);
                assert (this.getS0().nextSetBit(n6 + 1) == -1 || this.getS0().nextSetBit(n6 + 1) >= this.firstIndex[i + 1]);
            }
        }
        return true;
    }

    private boolean aContains(int[] nArray, int n) {
        for (int n2 : nArray) {
            if (n != n2) continue;
            return true;
        }
        return false;
    }

    public String ourRepToSaspString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("begin_version\n3\nend_version\n\n");
        stringBuilder.append("begin_metric\n");
        if (this.actionCosts) {
            stringBuilder.append("1");
        } else {
            stringBuilder.append("0");
        }
        stringBuilder.append("\nend_metric\n\n");
        stringBuilder.append(this.firstIndex.length + "\n");
        for (int i = 0; i < this.firstIndex.length; ++i) {
            stringBuilder.append("begin_variable\n");
            if (this.ranges[i] > 1) {
                stringBuilder.append("var" + (i + 1) + "\n");
                stringBuilder.append("-1\n");
                stringBuilder.append(this.ranges[i] + "\n");
                for (n = this.firstIndex[i]; n <= this.lastIndex[i]; ++n) {
                    stringBuilder.append("Atom " + this.factStrs[n].substring(this.factStrs[n].indexOf("=") + 1) + "\n");
                }
            } else {
                stringBuilder.append(this.factStrs[this.firstIndex[i]].substring(this.factStrs[this.firstIndex[i]].indexOf("=") + 1).replaceAll(" ", "_") + "\n");
                stringBuilder.append("-1\n");
                stringBuilder.append("2\n");
                stringBuilder.append("Atom TRUE()\n");
                stringBuilder.append("Atom FALSE()\n");
            }
            stringBuilder.append("end_variable\n\n");
        }
        stringBuilder.append("0\n\n");
        stringBuilder.append("begin_state\n");
        BitSet bitSet = this.getS0();
        for (n = 0; n < this.firstIndex.length; ++n) {
            if (this.ranges[n] > 1) {
                int n2 = bitSet.nextSetBit(this.firstIndex[n]) - this.firstIndex[n];
                stringBuilder.append(n2 + "\n");
                continue;
            }
            if (bitSet.get(this.firstIndex[n])) {
                stringBuilder.append("0\n");
                continue;
            }
            stringBuilder.append("1\n");
        }
        stringBuilder.append("end_state\n\n");
        stringBuilder.append("begin_goal\n");
        stringBuilder.append(this.gList.length + "\n");
        for (int n3 : this.gList) {
            int n4 = this.indexToMutexGroup[n3];
            int n5 = n3 - this.firstIndex[n4];
            stringBuilder.append(n4 + " " + n5 + "\n");
        }
        stringBuilder.append("end_goal\n\n");
        stringBuilder.append(this.numOfOperators + "\n\n");
        for (int i = 0; i < this.numOfOperators; ++i) {
            int n6;
            int n7;
            stringBuilder.append("begin_operator\n");
            stringBuilder.append(this.opNames[i] + "\n");
            HashSet hashSet = new HashSet();
            HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
            HashMap<Integer, Integer> hashMap2 = new HashMap<Integer, Integer>();
            for (int n8 : this.precLists[i]) {
                n7 = this.indexToMutexGroup[n8];
                n6 = n8 - this.firstIndex[n7];
                hashMap.put(n7, n6);
            }
            for (int n8 : this.addLists[i]) {
                n7 = this.indexToMutexGroup[n8];
                n6 = n8 - this.firstIndex[n7];
                hashMap2.put(n7, n6);
            }
            hashSet.addAll(hashMap.keySet());
            hashSet.addAll(hashMap2.keySet());
            Object object = new ArrayList();
            ArrayList<String> arrayList = new ArrayList<String>();
            Iterator iterator2 = hashSet.iterator();
            while (iterator2.hasNext()) {
                int n8;
                n8 = (Integer)iterator2.next();
                if (hashMap.containsKey(n8) && !hashMap2.containsKey(n8)) {
                    object.add(n8 + " " + hashMap.get(n8) + "\n");
                    continue;
                }
                if (hashMap.containsKey(n8) && hashMap2.containsKey(n8)) {
                    arrayList.add("0 " + n8 + " " + hashMap.get(n8) + " " + hashMap2.get(n8) + "\n");
                    continue;
                }
                if (hashMap.containsKey(n8) || !hashMap2.containsKey(n8)) continue;
                arrayList.add("0 " + n8 + " -1 " + hashMap2.get(n8) + "\n");
            }
            stringBuilder.append(object.size() + "\n");
            iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                stringBuilder.append(string2);
            }
            stringBuilder.append(arrayList.size() + "\n");
            for (String string3 : arrayList) {
                stringBuilder.append(string3);
            }
            stringBuilder.append(this.costs[i] + "\n");
            stringBuilder.append("end_operator\n\n");
        }
        return stringBuilder.toString();
    }

    public String getStatistics() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" - model has " + this.numOfOperators + " operators\n");
        stringBuilder.append(" - model has " + this.numOfStateFeatures + " state features\n");
        stringBuilder.append(" - operators' mean count of (pre, add, del) = (" + this.meanCount(this.precLists) + ", " + this.meanCount(this.addLists) + ", " + this.meanCount(this.delLists) + ")\n");
        stringBuilder.append(" - effects' mean achiever count: " + this.meanCount(this.addLists) + "\n");
        stringBuilder.append(" - effects' mean consumer count: " + this.meanCount(this.precToTask) + "\n");
        return stringBuilder.toString();
    }

    private String meanCount(int[][] nArray) {
        double d = 0.0;
        for (int[] nArray2 : nArray) {
            d += (double)nArray2.length;
        }
        return this.f.format(d / (double)this.precLists.length);
    }
}

