/*
 * Decompiled with CFR 0.152.
 */
package de.uniulm.ki.panda3.progression.htn.search;

import de.uniulm.ki.panda3.progression.heuristics.htn.GroundedProgressionHeuristic;
import de.uniulm.ki.panda3.progression.htn.ProPlanningInstance;
import de.uniulm.ki.panda3.progression.htn.representation.ProMethod;
import de.uniulm.ki.panda3.progression.htn.representation.ProSubtaskNetwork;
import de.uniulm.ki.panda3.progression.htn.representation.SasPlusProblem;
import de.uniulm.ki.panda3.progression.htn.search.ProgressionPlanStep;
import de.uniulm.ki.panda3.progression.htn.search.SolutionStep;
import de.uniulm.ki.panda3.symbolic.domain.Task;
import java.util.AbstractCollection;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ProgressionNetwork
implements Comparable<ProgressionNetwork>,
Cloneable {
    public static SasPlusProblem flatProblem;
    public static Task[] indexToTask;
    public static Map<Task, Integer> taskToIndex;
    public static Map<Task, List<ProMethod>> methods;
    public static Set<Integer> ShopPrecActions;
    public BitSet state;
    List<ProgressionPlanStep> unconstraintPrimitiveTasks;
    List<ProgressionPlanStep> unconstraintAbstractTasks;
    public int numProgressionSteps = 0;
    public int numSHOPProgressionSteps = 0;
    public int numDecompositionSteps = 0;
    private boolean printProgressionTrace = false;
    public String progressionTrace;
    public GroundedProgressionHeuristic heuristic;
    public int heuristicVal = 0;
    public int metric = 0;
    public boolean goalRelaxedReachable = true;
    public int id = 0;
    private int numberOfTasks = 0;
    private int numberOfPrimitiveTasks = 0;
    public SolutionStep solution;
    public static boolean useHelpfulActions;
    public BitSet helpfulActions;

    public boolean isHelpFulAction(int n) {
        if (!useHelpfulActions) {
            return false;
        }
        return this.helpfulActions.get(n);
    }

    public boolean isHelpFulMethod(ProMethod proMethod) {
        if (!useHelpfulActions) {
            return false;
        }
        return this.helpfulActions.get(proMethod.methodID);
    }

    private ProgressionNetwork() {
    }

    public ProgressionNetwork(BitSet bitSet, List<ProgressionPlanStep> list) {
        this.unconstraintPrimitiveTasks = new LinkedList<ProgressionPlanStep>();
        this.unconstraintAbstractTasks = new LinkedList<ProgressionPlanStep>();
        for (ProgressionPlanStep progressionPlanStep : list) {
            if (progressionPlanStep.isPrimitive) {
                this.unconstraintPrimitiveTasks.add(progressionPlanStep);
                ++this.numberOfTasks;
                ++this.numberOfPrimitiveTasks;
                continue;
            }
            this.unconstraintAbstractTasks.add(progressionPlanStep);
            ++this.numberOfTasks;
        }
        this.solution = new SolutionStep();
        if (this.printProgressionTrace) {
            System.out.println("WARNING: The system is recording a full decomposition trace - this is VERY slow and only recommended for debugging.");
            this.progressionTrace = "\nPROGRESSION-TRACE:\n\n";
            this.progressionTrace = this.progressionTrace + this.toString();
        }
        this.state = bitSet;
    }

    public boolean empty() {
        return this.unconstraintPrimitiveTasks.isEmpty() && this.unconstraintAbstractTasks.isEmpty();
    }

    public List<ProgressionPlanStep> getFirstPrimitiveTasks() {
        return this.unconstraintPrimitiveTasks;
    }

    public List<ProgressionPlanStep> getFirstAbstractTasks() {
        return this.unconstraintAbstractTasks;
    }

    @Deprecated
    public List<ProgressionPlanStep> getFirst() {
        LinkedList<ProgressionPlanStep> linkedList = new LinkedList<ProgressionPlanStep>();
        linkedList.addAll(this.unconstraintAbstractTasks);
        linkedList.addAll(this.unconstraintPrimitiveTasks);
        return linkedList;
    }

    public String toString() {
        return ProgressionNetwork.networkToString(this.unconstraintAbstractTasks, this.unconstraintPrimitiveTasks);
    }

    public static String networkToString(List<ProgressionPlanStep> list, List<ProgressionPlanStep> list2) {
        Object object3;
        HashMap hashMap;
        int n = 0;
        HashMap<ProgressionPlanStep, Integer> hashMap2 = new HashMap<ProgressionPlanStep, Integer>();
        LinkedList<int[]> linkedList = new LinkedList<int[]>();
        LinkedList<ProgressionPlanStep> linkedList2 = new LinkedList<ProgressionPlanStep>();
        for (ProgressionPlanStep progressionPlanStep : list) {
            linkedList2.add(progressionPlanStep);
            hashMap2.put(progressionPlanStep, n++);
        }
        for (ProgressionPlanStep progressionPlanStep : list2) {
            linkedList2.add(progressionPlanStep);
            hashMap2.put(progressionPlanStep, n++);
        }
        while (!linkedList2.isEmpty()) {
            hashMap = (ProgressionPlanStep)linkedList2.removeFirst();
            int n2 = (Integer)hashMap2.get(hashMap);
            for (ProgressionPlanStep progressionPlanStep : ((ProgressionPlanStep)((Object)hashMap)).successorList) {
                if (!hashMap2.containsKey(progressionPlanStep)) {
                    hashMap2.put(progressionPlanStep, n++);
                    linkedList2.add(progressionPlanStep);
                }
                int n3 = (Integer)hashMap2.get(progressionPlanStep);
                object3 = new int[]{n2, n3};
                linkedList.add((int[])object3);
            }
        }
        hashMap = new HashMap();
        for (Object object2 : hashMap2.keySet()) {
            hashMap.put(hashMap2.get(object2), object2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("tasks={");
        int n4 = 0;
        while (hashMap.containsKey(n4)) {
            ProgressionPlanStep progressionPlanStep;
            progressionPlanStep = (ProgressionPlanStep)hashMap.get(n4);
            if (n4 > 0) {
                stringBuilder.append(", ");
                stringBuilder.append("\n       ");
            }
            stringBuilder.append(n4);
            stringBuilder.append(":");
            stringBuilder.append(progressionPlanStep.getTask().shortInfo());
            ++n4;
        }
        boolean bl = true;
        stringBuilder.append("},\norderings={");
        for (Object object3 : linkedList) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append("(");
            stringBuilder.append(object3[0]);
            stringBuilder.append("<");
            stringBuilder.append(object3[1]);
            stringBuilder.append(")");
        }
        bl = true;
        stringBuilder.append("}\nnext={");
        Iterator<Object> iterator2 = list.iterator();
        while (iterator2.hasNext()) {
            object3 = (ProgressionPlanStep)iterator2.next();
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(hashMap2.get(object3));
        }
        iterator2 = list2.iterator();
        while (iterator2.hasNext()) {
            object3 = (ProgressionPlanStep)iterator2.next();
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(hashMap2.get(object3));
        }
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    public ProgressionNetwork decompose(ProgressionPlanStep progressionPlanStep, ProMethod proMethod) {
        ProgressionNetwork progressionNetwork = this.clone();
        --progressionNetwork.numberOfTasks;
        progressionNetwork.numberOfTasks += proMethod.numberOfAbsSubtasks;
        progressionNetwork.numberOfTasks += proMethod.numberOfPrimSubtasks;
        progressionNetwork.state = this.state;
        progressionNetwork.solution = new SolutionStep(this.solution, proMethod.m);
        ++progressionNetwork.numDecompositionSteps;
        progressionNetwork.unconstraintAbstractTasks.remove(progressionPlanStep);
        ProSubtaskNetwork proSubtaskNetwork = proMethod.instantiate();
        assert (proSubtaskNetwork.size() > 0);
        assert (proSubtaskNetwork.getLastNodes().size() > 0);
        assert (proSubtaskNetwork.getFirstNodes().size() > 0);
        List<ProgressionPlanStep> list = proSubtaskNetwork.getLastNodes();
        for (ProgressionPlanStep progressionPlanStep2 : list) {
            progressionPlanStep2.successorList.addAll(progressionPlanStep.successorList);
        }
        for (ProgressionPlanStep progressionPlanStep2 : proSubtaskNetwork.getFirstNodes()) {
            if (progressionPlanStep2.isPrimitive) {
                progressionNetwork.unconstraintPrimitiveTasks.add(progressionPlanStep2);
                continue;
            }
            progressionNetwork.unconstraintAbstractTasks.add(progressionPlanStep2);
        }
        if (this.printProgressionTrace) {
            progressionNetwork.progressionTrace = progressionNetwork.progressionTrace + "\n";
            progressionNetwork.progressionTrace = progressionNetwork.progressionTrace + progressionNetwork.toString();
        }
        return progressionNetwork;
    }

    public ProgressionNetwork apply(ProgressionPlanStep progressionPlanStep) {
        Object object;
        ProgressionNetwork progressionNetwork = this.clone();
        --progressionNetwork.numberOfTasks;
        --progressionNetwork.numberOfPrimitiveTasks;
        progressionNetwork.state = (BitSet)this.state.clone();
        progressionNetwork.solution = new SolutionStep(this.solution, progressionPlanStep.action);
        if (ShopPrecActions.contains(progressionPlanStep.action)) {
            ++progressionNetwork.numSHOPProgressionSteps;
        } else {
            ++progressionNetwork.numProgressionSteps;
        }
        progressionNetwork.unconstraintPrimitiveTasks.remove(progressionPlanStep);
        assert (this.isApplicable(progressionNetwork.state, progressionPlanStep.action));
        for (int n : ProgressionNetwork.flatProblem.delLists[progressionPlanStep.action]) {
            progressionNetwork.state.set(n, false);
        }
        for (int n : ProgressionNetwork.flatProblem.addLists[progressionPlanStep.action]) {
            progressionNetwork.state.set(n, true);
        }
        Object object2 = new HashSet();
        ((AbstractCollection)object2).addAll(progressionPlanStep.successorList);
        LinkedList<ProgressionPlanStep> linkedList = new LinkedList<ProgressionPlanStep>();
        for (ProgressionPlanStep progressionPlanStep2 : progressionNetwork.unconstraintAbstractTasks) {
            linkedList.addAll(progressionPlanStep2.successorList);
        }
        for (ProgressionPlanStep progressionPlanStep3 : progressionNetwork.unconstraintPrimitiveTasks) {
            linkedList.addAll(progressionPlanStep3.successorList);
        }
        for (ProgressionPlanStep progressionPlanStep4 : progressionPlanStep.successorList) {
            linkedList.addAll(progressionPlanStep4.successorList);
        }
        while (!((HashSet)object2).isEmpty() && !linkedList.isEmpty()) {
            object = (ProgressionPlanStep)linkedList.removeFirst();
            linkedList.addAll(((ProgressionPlanStep)object).successorList);
            ((HashSet)object2).remove(object);
        }
        object = ((HashSet)object2).iterator();
        while (object.hasNext()) {
            ProgressionPlanStep progressionPlanStep5 = (ProgressionPlanStep)object.next();
            if (progressionPlanStep5.isPrimitive) {
                progressionNetwork.unconstraintPrimitiveTasks.add(progressionPlanStep5);
                continue;
            }
            progressionNetwork.unconstraintAbstractTasks.add(progressionPlanStep5);
        }
        if (this.printProgressionTrace) {
            progressionNetwork.progressionTrace = progressionNetwork.progressionTrace + "\n";
            progressionNetwork.progressionTrace = progressionNetwork.progressionTrace + progressionNetwork.toString();
        }
        return progressionNetwork;
    }

    private boolean isApplicable(BitSet bitSet, int n) {
        for (int n2 : ProgressionNetwork.flatProblem.precLists[n]) {
            if (bitSet.get(n2)) continue;
            return false;
        }
        return true;
    }

    public boolean isApplicable(int n) {
        for (int n2 : ProgressionNetwork.flatProblem.precLists[n]) {
            if (this.state.get(n2)) continue;
            return false;
        }
        return true;
    }

    public boolean isGoal() {
        if (!this.empty()) {
            return false;
        }
        for (int n : ProgressionNetwork.flatProblem.gList) {
            if (this.state.get(n)) continue;
            return false;
        }
        return true;
    }

    protected ProgressionNetwork clone() {
        ProgressionNetwork progressionNetwork = new ProgressionNetwork();
        progressionNetwork.numberOfPrimitiveTasks = this.numberOfPrimitiveTasks;
        progressionNetwork.numberOfTasks = this.numberOfTasks;
        progressionNetwork.unconstraintPrimitiveTasks = new LinkedList<ProgressionPlanStep>();
        progressionNetwork.unconstraintAbstractTasks = new LinkedList<ProgressionPlanStep>();
        progressionNetwork.unconstraintPrimitiveTasks.addAll(this.unconstraintPrimitiveTasks);
        progressionNetwork.unconstraintAbstractTasks.addAll(this.unconstraintAbstractTasks);
        progressionNetwork.solution = this.solution;
        if (this.printProgressionTrace) {
            progressionNetwork.progressionTrace = this.progressionTrace;
        }
        progressionNetwork.numDecompositionSteps = this.numDecompositionSteps;
        progressionNetwork.numProgressionSteps = this.numProgressionSteps;
        progressionNetwork.numSHOPProgressionSteps = this.numSHOPProgressionSteps;
        return progressionNetwork;
    }

    @Override
    public int compareTo(ProgressionNetwork progressionNetwork) {
        int n = this.metric - progressionNetwork.metric;
        if (n == 0) {
            n = ProPlanningInstance.random.nextBoolean() ? 1 : -1;
        }
        return n;
    }

    public int getNumberOfTasks() {
        return this.numberOfTasks;
    }

    public int getNumberOfPrimitiveTasks() {
        return this.numberOfPrimitiveTasks;
    }

    static {
        ShopPrecActions = new HashSet<Integer>();
        useHelpfulActions = false;
    }
}

