/*
 * Decompiled with CFR 0.152.
 */
package de.uniulm.ki.panda3.progression.htn.search;

import de.uniulm.ki.panda3.progression.htn.search.ProgressionNetwork;
import de.uniulm.ki.panda3.symbolic.domain.SimpleDecompositionMethod;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

public class SolutionStep {
    private SolutionStep predecessor = null;
    private int action;
    private SimpleDecompositionMethod method;
    protected int length;
    protected int primitiveCount;
    protected int shopCount;

    public SolutionStep() {
        this.length = 0;
        this.primitiveCount = 0;
        this.shopCount = 0;
    }

    public SolutionStep(SolutionStep solutionStep, int n) {
        this.predecessor = solutionStep;
        this.action = n;
        this.length = solutionStep.length + 1;
        this.primitiveCount = solutionStep.primitiveCount;
        this.shopCount = solutionStep.shopCount;
        if (!ProgressionNetwork.ShopPrecActions.contains(n)) {
            ++this.primitiveCount;
        } else {
            ++this.shopCount;
        }
    }

    public SolutionStep(SolutionStep solutionStep, SimpleDecompositionMethod simpleDecompositionMethod) {
        this.predecessor = solutionStep;
        this.method = simpleDecompositionMethod;
        this.length = solutionStep.length + 1;
        this.primitiveCount = solutionStep.primitiveCount;
        this.shopCount = solutionStep.shopCount;
    }

    public String toString() {
        if (this.predecessor != null) {
            String string2 = this.method != null ? this.method.name() + " @ " + this.method.abstractTask().shortInfo() : ProgressionNetwork.flatProblem.opNames[this.action];
            String string3 = "";
            string3 = this.predecessor.toString();
            if (string3.length() > 0) {
                string2 = "\n" + string2;
            }
            return string3 + string2;
        }
        return "";
    }

    public boolean isFirst() {
        return this.predecessor == null;
    }

    public int getLength() {
        return this.length - this.shopCount;
    }

    public int getPrimitiveCount() {
        return this.primitiveCount;
    }

    public List<Object> getSolution() {
        if (this.isFirst()) {
            return new LinkedList<Object>();
        }
        List<Object> list = this.predecessor.getSolution();
        Serializable serializable = this.method != null ? this.method : Integer.valueOf(this.action);
        ((LinkedList)list).add(serializable);
        return list;
    }
}

