/*
 * Decompiled with CFR 0.152.
 */
package de.uniulm.ki.panda3.progression.htn.search.loopDetection;

import de.uniulm.ki.panda3.progression.htn.search.ProgressionNetwork;
import de.uniulm.ki.panda3.progression.htn.search.ProgressionPlanStep;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VisitedList {
    private static final short cUnequal = -1;
    private static final short cIdentical = 0;
    private static final short cRefIdentical = 1;
    private final Map<Integer, Map<Integer, Map<BitSet, List<List<ProgressionPlanStep>[]>>>> visited = new HashMap<Integer, Map<Integer, Map<BitSet, List<List<ProgressionPlanStep>[]>>>>();
    private int calls = 0;
    private int hits = 0;
    private long totaltime = 0L;

    public int getNumCalls() {
        return this.calls;
    }

    public int getNumHits() {
        return this.hits;
    }

    public long getTotalTime() {
        return this.totaltime;
    }

    public boolean addIfNotIn(ProgressionNetwork progressionNetwork) {
        long l = System.currentTimeMillis();
        ++this.calls;
        int n = progressionNetwork.getNumberOfTasks();
        Map<Integer, Map<BitSet, List<List<ProgressionPlanStep>[]>>> map2 = this.visited.get(n);
        if (map2 == null) {
            List[] listArray = new List[]{progressionNetwork.getFirstPrimitiveTasks(), progressionNetwork.getFirstAbstractTasks()};
            LinkedList<List[]> linkedList = new LinkedList<List[]>();
            linkedList.add(listArray);
            HashMap<BitSet, LinkedList<List[]>> hashMap = new HashMap<BitSet, LinkedList<List[]>>();
            hashMap.put(progressionNetwork.state, linkedList);
            map2 = new HashMap<Integer, Map<BitSet, List<List<ProgressionPlanStep>[]>>>();
            map2.put(progressionNetwork.getNumberOfPrimitiveTasks(), hashMap);
            this.visited.put(n, map2);
            this.totaltime += System.currentTimeMillis() - l;
            return false;
        }
        n = progressionNetwork.getNumberOfPrimitiveTasks();
        Map<BitSet, List<List<ProgressionPlanStep>[]>> map3 = map2.get(n);
        if (map3 == null) {
            List[] listArray = new List[]{progressionNetwork.getFirstPrimitiveTasks(), progressionNetwork.getFirstAbstractTasks()};
            LinkedList<List[]> linkedList = new LinkedList<List[]>();
            linkedList.add(listArray);
            map3 = new HashMap<BitSet, List<List<ProgressionPlanStep>[]>>();
            map3.put(progressionNetwork.state, linkedList);
            map2.put(progressionNetwork.getNumberOfPrimitiveTasks(), map3);
            this.totaltime += System.currentTimeMillis() - l;
            return false;
        }
        List<List<ProgressionPlanStep>[]> list = map3.get(progressionNetwork.state);
        if (list == null) {
            List[] listArray = new List[]{progressionNetwork.getFirstPrimitiveTasks(), progressionNetwork.getFirstAbstractTasks()};
            list = new LinkedList<List<ProgressionPlanStep>[]>();
            list.add(listArray);
            map3.put(progressionNetwork.state, list);
            this.totaltime += System.currentTimeMillis() - l;
            return false;
        }
        for (List<ProgressionPlanStep>[] listArray : list) {
            String string2 = ProgressionNetwork.networkToString(listArray[0], listArray[1]);
            if (!this.equalNetworks(progressionNetwork.getFirstPrimitiveTasks(), progressionNetwork.getFirstAbstractTasks(), listArray[0], listArray[1])) continue;
            ++this.hits;
            this.totaltime += System.currentTimeMillis() - l;
            return true;
        }
        List[] listArray = new List[]{progressionNetwork.getFirstPrimitiveTasks(), progressionNetwork.getFirstAbstractTasks()};
        list.add(listArray);
        this.totaltime += System.currentTimeMillis() - l;
        return false;
    }

    private boolean equalNetworks(List<ProgressionPlanStep> list, List<ProgressionPlanStep> list2, List<ProgressionPlanStep> list3, List<ProgressionPlanStep> list4) {
        HashMap<ProgressionPlanStep, ProgressionPlanStep> hashMap = new HashMap<ProgressionPlanStep, ProgressionPlanStep>();
        HashMap<ProgressionPlanStep, ProgressionPlanStep> hashMap2 = new HashMap<ProgressionPlanStep, ProgressionPlanStep>();
        if (list.size() != list3.size() || list2.size() != list4.size()) {
            return false;
        }
        ProgressionPlanStep[] progressionPlanStepArray = new ProgressionPlanStep[list.size()];
        ProgressionPlanStep[] progressionPlanStepArray2 = new ProgressionPlanStep[list2.size()];
        Iterator<ProgressionPlanStep> iterator2 = list.iterator();
        for (int i = 0; i < list.size(); ++i) {
            progressionPlanStepArray[i] = iterator2.next();
        }
        Iterator<ProgressionPlanStep> iterator3 = list2.iterator();
        for (int i = 0; i < list2.size(); ++i) {
            progressionPlanStepArray2[i] = iterator3.next();
        }
        Iterator[] iteratorArray = new Iterator[list.size()];
        Iterator[] iteratorArray2 = new Iterator[list2.size()];
        if (!this.initMappings(hashMap, hashMap2, progressionPlanStepArray, list3, iteratorArray) || !this.initMappings(hashMap, hashMap2, progressionPlanStepArray2, list4, iteratorArray2)) {
            return false;
        }
        boolean bl = true;
        boolean bl2 = true;
        while (bl) {
            while (bl2) {
                HashSet<ProgressionPlanStep> hashSet = new HashSet<ProgressionPlanStep>();
                hashSet.addAll(list);
                hashSet.addAll(list2);
                if (this.checkRestOfNetwork(hashSet, hashMap, hashMap2)) {
                    return true;
                }
                bl2 = this.getNextMapping(progressionPlanStepArray2, list4, null, iteratorArray2, hashMap, hashMap2);
            }
            bl = this.getNextMapping(progressionPlanStepArray, list3, null, iteratorArray, hashMap, hashMap2);
            if (!bl) continue;
            bl2 = this.initMappings(hashMap, hashMap2, progressionPlanStepArray2, list4, iteratorArray2);
        }
        return false;
    }

    private boolean initMappings(HashMap<ProgressionPlanStep, ProgressionPlanStep> hashMap, HashMap<ProgressionPlanStep, ProgressionPlanStep> hashMap2, ProgressionPlanStep[] progressionPlanStepArray, List<ProgressionPlanStep> list, Iterator<ProgressionPlanStep>[] iteratorArray) {
        for (int i = 0; i < iteratorArray.length; ++i) {
            iteratorArray[i] = list.iterator();
            ProgressionPlanStep progressionPlanStep = iteratorArray[i].next();
            while (this.compatible(progressionPlanStepArray[i], progressionPlanStep) == -1) {
                if (!iteratorArray[i].hasNext()) {
                    return false;
                }
                progressionPlanStep = iteratorArray[i].next();
            }
            hashMap.put(progressionPlanStepArray[i], progressionPlanStep);
            hashMap2.put(progressionPlanStep, progressionPlanStepArray[i]);
        }
        return true;
    }

    private boolean getNextMapping(ProgressionPlanStep[] progressionPlanStepArray, List<ProgressionPlanStep> list, Set<ProgressionPlanStep>[] setArray, Iterator<ProgressionPlanStep>[] iteratorArray, HashMap<ProgressionPlanStep, ProgressionPlanStep> hashMap, HashMap<ProgressionPlanStep, ProgressionPlanStep> hashMap2) {
        block0: for (int i = iteratorArray.length - 1; i >= 0; --i) {
            hashMap2.remove(hashMap.remove(progressionPlanStepArray[i]));
            boolean bl = false;
            boolean bl2 = false;
            while (iteratorArray[i].hasNext() || !bl2) {
                if (iteratorArray[i].hasNext()) {
                    ProgressionPlanStep progressionPlanStep = iteratorArray[i].next();
                    if (this.compatible(progressionPlanStepArray[i], progressionPlanStep) == -1) continue;
                    hashMap.put(progressionPlanStepArray[i], progressionPlanStep);
                    hashMap2.put(progressionPlanStep, progressionPlanStepArray[i]);
                    if (!bl2) break block0;
                    bl = true;
                    continue;
                }
                if (bl2 || i <= 0) continue;
                bl2 = true;
                if (list != null) {
                    iteratorArray[i] = list.iterator();
                    continue;
                }
                iteratorArray[i] = setArray[i].iterator();
            }
            if (bl) continue;
            for (int j = i + 1; j < iteratorArray.length; ++j) {
                hashMap2.remove(hashMap.remove(progressionPlanStepArray[j]));
            }
            return false;
        }
        return true;
    }

    private boolean checkRestOfNetwork(Set<ProgressionPlanStep> set, HashMap<ProgressionPlanStep, ProgressionPlanStep> hashMap, HashMap<ProgressionPlanStep, ProgressionPlanStep> hashMap2) {
        HashSet<ProgressionPlanStep> hashSet = new HashSet<ProgressionPlanStep>();
        ProgressionPlanStep[] progressionPlanStepArray = new ProgressionPlanStep[set.size()];
        Set[] setArray = new Set[set.size()];
        Iterator[] iteratorArray = new Iterator[set.size()];
        int n = 0;
        for (ProgressionPlanStep progressionPlanStep : set) {
            hashSet.addAll(progressionPlanStep.successorList);
            Set<ProgressionPlanStep> set2 = hashMap.get((Object)progressionPlanStep).successorList;
            Iterator<ProgressionPlanStep> iterator2 = set2.iterator();
            boolean bl = false;
            while (iterator2.hasNext()) {
                ProgressionPlanStep progressionPlanStep2 = iterator2.next();
                if (this.compatible(progressionPlanStep, progressionPlanStep2) == -1 || hashMap.containsKey(progressionPlanStep) && !hashMap.get(progressionPlanStep).equals(progressionPlanStep2)) continue;
                bl = true;
                hashMap.put(progressionPlanStep, progressionPlanStep2);
                hashMap2.put(progressionPlanStep2, progressionPlanStep);
                break;
            }
            if (!bl) {
                for (int i = 0; i < n; ++i) {
                    hashMap2.remove(hashMap.remove(progressionPlanStepArray[i]));
                }
                return false;
            }
            progressionPlanStepArray[n] = progressionPlanStep;
            setArray[n] = set2;
            iteratorArray[n] = iterator2;
            ++n;
        }
        boolean bl = true;
        while (bl) {
            if (this.checkRestOfNetwork(hashSet, hashMap, hashMap2)) {
                return true;
            }
            bl = this.getNextMapping(progressionPlanStepArray, null, setArray, iteratorArray, hashMap, hashMap2);
        }
        return false;
    }

    private short compatible(ProgressionPlanStep progressionPlanStep, ProgressionPlanStep progressionPlanStep2) {
        if (!progressionPlanStep.getTask().equals(progressionPlanStep2.getTask())) {
            return -1;
        }
        if (progressionPlanStep.successorList.size() != progressionPlanStep2.successorList.size()) {
            return -1;
        }
        return 0;
    }
}

