/*
 * Decompiled with CFR 0.152.
 */
package de.uniulm.ki.panda3.progression.htn.search.searchRoutine;

import de.uniulm.ki.panda3.progression.TDGReachabilityAnalysis.TaskReachabilityGraph;
import de.uniulm.ki.panda3.progression.htn.ProPlanningInstance;
import de.uniulm.ki.panda3.progression.htn.representation.ProMethod;
import de.uniulm.ki.panda3.progression.htn.search.ProgressionNetwork;
import de.uniulm.ki.panda3.progression.htn.search.ProgressionPlanStep;
import de.uniulm.ki.panda3.progression.htn.search.SolutionStep;
import de.uniulm.ki.panda3.progression.htn.search.fringe.AlternatingFringe;
import de.uniulm.ki.panda3.progression.htn.search.fringe.IFringe;
import de.uniulm.ki.panda3.progression.htn.search.fringe.QueueBasedFringe;
import de.uniulm.ki.panda3.progression.htn.search.searchRoutine.ProgressionSearchRoutine;
import de.uniulm.ki.panda3.symbolic.domain.GroundedDecompositionMethod;
import de.uniulm.ki.panda3.symbolic.domain.SimpleDecompositionMethod;
import de.uniulm.ki.panda3.symbolic.domain.Task;
import de.uniulm.ki.panda3.symbolic.plan.element.GroundTask;
import de.uniulm.ki.panda3.symbolic.plan.element.PlanStep;
import de.uniulm.ki.util.InformationCapsule;
import de.uniulm.ki.util.TimeCapsule;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.PriorityQueue;

public class PriorityQueueSearch
extends ProgressionSearchRoutine {
    public int greediness = 1;
    public static final String SEARCH_TIME = "30 progression:01:searchTime";
    public static final String STATUS = "30 progression:01:status";
    public static final String A_STAR = "30 progression:02:aStar";
    public static final String HEURISTIC = "30 progression:03:heuristic";
    public static final String NUM_SEARCH_NODES = "30 progression:04:numSearchNodes";
    public static final String UNIT_PROPAGATION = "30 progression:05:unitPropagation";
    public static final String NUM_PRIM_TASKS = "30 progression:06:numPrimTasks";
    public static final String NUM_SHOP_TASKS = "30 progression:07:numShopTasks";
    public static final String NUM_DECOMPOSITIONS = "30 progression:08:numDecompositions";
    public static final String INFERRED_TLT = "30 progression:09:inferredTlt";
    public static final String ENFORCED_PREFIX_LENGTH = "30 progression:10:enforcedPrefixLength";
    public static final String SOLUTION = "30 progression:11:solution";
    private boolean findShortest = false;
    boolean aStar = true;
    boolean deleteRelaxed = false;
    boolean output = true;
    boolean exitDueToTimeLimit = false;
    abstractTaskSelection taskSelection = abstractTaskSelection.random;

    public PriorityQueueSearch() {
    }

    public PriorityQueueSearch(boolean bl, boolean bl2, boolean bl3, abstractTaskSelection abstractTaskSelection2) {
        this.aStar = bl;
        this.output = bl2;
        this.findShortest = bl3;
        this.taskSelection = abstractTaskSelection2;
    }

    @Override
    public SolutionStep search(ProgressionNetwork progressionNetwork) {
        InformationCapsule informationCapsule = new InformationCapsule();
        TimeCapsule timeCapsule = new TimeCapsule();
        return this.search(progressionNetwork, informationCapsule, timeCapsule);
    }

    @Override
    public SolutionStep search(ProgressionNetwork progressionNetwork, InformationCapsule informationCapsule, TimeCapsule timeCapsule) {
        IFringe<Object> iFringe;
        if (this.output) {
            System.out.println("\nStarting priority queue search");
        }
        int n = 1;
        int n2 = 0;
        int n3 = -1;
        long l = 0L;
        long l2 = 0L;
        int n4 = 0;
        SolutionStep solutionStep = null;
        long l3 = System.currentTimeMillis();
        long l4 = System.currentTimeMillis();
        if (progressionNetwork.heuristic.supportsHelpfulActions) {
            ProgressionNetwork.useHelpfulActions = true;
            iFringe = new AlternatingFringe();
            progressionNetwork.helpfulActions = new BitSet();
        } else {
            iFringe = new QueueBasedFringe<ProgressionNetwork>();
        }
        iFringe.add(progressionNetwork);
        long l5 = System.currentTimeMillis();
        boolean bl = false;
        LinkedList<Long> linkedList = new LinkedList<Long>();
        LinkedList<String> linkedList2 = new LinkedList<String>();
        int n5 = -1;
        long l6 = -1L;
        long l7 = -1L;
        boolean bl2 = false;
        timeCapsule.start(SEARCH_TIME);
        block0: while (!iFringe.isEmpty()) {
            ProgressionNetwork progressionNetwork2 = (ProgressionNetwork)iFringe.poll();
            for (ProgressionPlanStep n7 : progressionNetwork2.getFirstPrimitiveTasks()) {
                if (!progressionNetwork2.isApplicable(n7.action)) continue;
                Object object = progressionNetwork2.apply(n7);
                ((ProgressionNetwork)object).id = n;
                ((ProgressionNetwork)object).heuristic = progressionNetwork2.heuristic.update((ProgressionNetwork)object, n7);
                ((ProgressionNetwork)object).goalRelaxedReachable = ((ProgressionNetwork)object).heuristic.goalRelaxedReachable();
                if (!((ProgressionNetwork)object).goalRelaxedReachable) continue;
                ((ProgressionNetwork)object).heuristicVal = ((ProgressionNetwork)object).heuristic.getHeuristic();
                ((ProgressionNetwork)object).metric = this.aStar ? ((ProgressionNetwork)object).heuristicVal + ((ProgressionNetwork)object).solution.getLength() / this.greediness : ((ProgressionNetwork)object).heuristicVal;
                if (((ProgressionNetwork)object).heuristic.supportsHelpfulActions) {
                    ((ProgressionNetwork)object).helpfulActions = ((ProgressionNetwork)object).heuristic.helpfulOps();
                    bl2 = progressionNetwork2.isHelpFulAction(n7.action);
                }
                if (((ProgressionNetwork)object).isGoal()) {
                    int progressionNetwork3 = ((ProgressionNetwork)object).solution.getPrimitiveCount();
                    if (n2 == 0 || progressionNetwork3 < n3) {
                        if (n2 == 0) {
                            l = System.currentTimeMillis();
                        }
                        System.out.println("Found solution " + (n2 + 1) + " length " + progressionNetwork3);
                        solutionStep = ((ProgressionNetwork)object).solution;
                        l2 = System.currentTimeMillis();
                        n3 = progressionNetwork3;
                        if (((ProgressionNetwork)object).progressionTrace != null) {
                            System.out.println(((ProgressionNetwork)object).progressionTrace);
                        }
                    }
                    if (bl) {
                        this.collectPlanRecData(linkedList, linkedList2, (ProgressionNetwork)object);
                    }
                    ++n2;
                    if (this.findShortest || bl) continue;
                    break block0;
                }
                iFringe.add(object, bl2);
            }
            if (progressionNetwork2.getFirstAbstractTasks().size() == 0) continue;
            Object object3 = null;
            if (this.taskSelection == abstractTaskSelection.random) {
                object3 = progressionNetwork2.getFirstAbstractTasks().get(ProPlanningInstance.random.nextInt(progressionNetwork2.getFirstAbstractTasks().size()));
            } else if (this.taskSelection == abstractTaskSelection.methodCount) {
                int n8 = Integer.MAX_VALUE;
                for (ProgressionPlanStep progressionPlanStep : progressionNetwork2.getFirstAbstractTasks()) {
                    int n6;
                    if (progressionPlanStep.methods.size() < n6) {
                        n6 = progressionPlanStep.methods.size();
                        object3 = progressionPlanStep;
                        continue;
                    }
                    if (progressionPlanStep.methods.size() != n6 || !ProPlanningInstance.random.nextBoolean()) continue;
                    n6 = progressionPlanStep.methods.size();
                    object3 = progressionPlanStep;
                }
            } else {
                int n7 = Integer.MAX_VALUE;
                for (ProgressionPlanStep progressionPlanStep : progressionNetwork2.getFirstAbstractTasks()) {
                    int n8;
                    int n9 = TaskReachabilityGraph.maxDecompDepth[TaskReachabilityGraph.tToI(progressionPlanStep.getTask())];
                    if (n9 < n8) {
                        n8 = n9;
                        object3 = progressionPlanStep;
                        continue;
                    }
                    if (progressionPlanStep.methods.size() != n8 || !ProPlanningInstance.random.nextBoolean()) continue;
                    n8 = progressionPlanStep.methods.size();
                    object3 = progressionPlanStep;
                }
            }
            for (Object object : ((ProgressionPlanStep)object3).methods) {
                ProgressionNetwork progressionNetwork3 = progressionNetwork2.decompose((ProgressionPlanStep)object3, (ProMethod)object);
                progressionNetwork3.heuristic = progressionNetwork2.heuristic.update(progressionNetwork3, (ProgressionPlanStep)object3, (ProMethod)object);
                progressionNetwork3.id = n++;
                progressionNetwork3.goalRelaxedReachable = progressionNetwork3.heuristic.goalRelaxedReachable();
                if (!progressionNetwork3.goalRelaxedReachable) continue;
                progressionNetwork3.heuristicVal = progressionNetwork3.heuristic.getHeuristic();
                progressionNetwork3.metric = this.aStar ? progressionNetwork3.heuristicVal + progressionNetwork3.solution.getLength() / this.greediness : progressionNetwork3.heuristicVal;
                if (progressionNetwork3.heuristic.supportsHelpfulActions) {
                    progressionNetwork3.helpfulActions = progressionNetwork3.heuristic.helpfulOps();
                    bl2 = progressionNetwork2.isHelpFulMethod((ProMethod)object);
                }
                iFringe.add(progressionNetwork3, bl2);
            }
            if (System.currentTimeMillis() - l4 <= 1000L) continue;
            if (l6 > 0L && System.currentTimeMillis() - l3 > l7) {
                l7 = (long)(++n5) * l6;
                System.out.println("Seems to be a bad run, let's try again! -> restart");
                iFringe.clear();
                iFringe.add(progressionNetwork);
                continue;
            }
            if (this.wallTime > 0L && System.currentTimeMillis() - l3 > this.wallTime) {
                System.out.println("Reached time limit, search will stop.");
                this.exitDueToTimeLimit = true;
                break;
            }
            l4 = System.currentTimeMillis();
            if (!this.output) continue;
            System.out.println(this.getInfoStr(n, iFringe.size(), this.greediness, progressionNetwork2, l3));
        }
        System.out.println("Number of nodes in final fringe: " + iFringe.size());
        timeCapsule.stop(SEARCH_TIME);
        if (this.findShortest) {
            informationCapsule.add("30 progression:91:findShortestPlan", 1);
        } else {
            informationCapsule.add("30 progression:91:findShortestPlan", 0);
        }
        informationCapsule.add("30 progression:92:foundShortestPlanAfter", (int)(l - l5));
        informationCapsule.add("30 progression:93:foundFirstPlanAfter", (int)(l2 - l5));
        informationCapsule.add("30 progression:94:foundPlans", n2);
        if (solutionStep != null) {
            informationCapsule.set(STATUS, "solved");
        } else if (this.exitDueToTimeLimit) {
            informationCapsule.set(STATUS, "timeout");
        } else {
            informationCapsule.set(STATUS, "proven_unsolvable");
        }
        if (this.aStar) {
            informationCapsule.set(A_STAR, 1);
        } else {
            informationCapsule.set(A_STAR, 0);
        }
        informationCapsule.set(HEURISTIC, progressionNetwork.heuristic.getName());
        informationCapsule.set(NUM_SEARCH_NODES, n);
        informationCapsule.set(UNIT_PROPAGATION, n4);
        this.setSolInfo(solutionStep, informationCapsule);
        if (this.output) {
            System.out.println("Generated search nodes (total): " + n);
            System.out.println("Search time: " + (System.currentTimeMillis() - l3) + " ms");
        }
        return solutionStep;
    }

    public SolutionStep searchWithAbstractBranching(ProgressionNetwork progressionNetwork, InformationCapsule informationCapsule, TimeCapsule timeCapsule) {
        if (this.output) {
            System.out.println("\nStarting priority queue search");
        }
        int n = 1;
        int n2 = 0;
        int n3 = -1;
        long l = 0L;
        long l2 = 0L;
        int n4 = 0;
        int n5 = Integer.MAX_VALUE;
        SolutionStep solutionStep = null;
        long l3 = System.currentTimeMillis();
        long l4 = System.currentTimeMillis();
        PriorityQueue<Object> priorityQueue = new PriorityQueue<Object>();
        priorityQueue.add(progressionNetwork);
        timeCapsule.start(SEARCH_TIME);
        long l5 = System.currentTimeMillis();
        boolean bl = false;
        LinkedList<Long> linkedList = new LinkedList<Long>();
        LinkedList<String> linkedList2 = new LinkedList<String>();
        int n6 = -1;
        long l6 = -1L;
        long l7 = -1L;
        block0: while (!priorityQueue.isEmpty()) {
            ProgressionNetwork progressionNetwork2 = (ProgressionNetwork)priorityQueue.poll();
            for (ProgressionPlanStep progressionPlanStep : progressionNetwork2.getFirstPrimitiveTasks()) {
                if (!progressionNetwork2.isApplicable(progressionPlanStep.action)) continue;
                ProgressionNetwork progressionNetwork3 = progressionNetwork2.apply(progressionPlanStep);
                progressionNetwork3.id = n;
                progressionNetwork3.heuristic = progressionNetwork2.heuristic.update(progressionNetwork3, progressionPlanStep);
                progressionNetwork3.metric = progressionNetwork3.heuristic.getHeuristic();
                if (this.aStar) {
                    progressionNetwork3.metric += progressionNetwork3.solution.getLength();
                }
                progressionNetwork3.goalRelaxedReachable = progressionNetwork3.heuristic.goalRelaxedReachable();
                if (progressionNetwork3.goalRelaxedReachable) {
                    if (progressionNetwork3.isGoal()) {
                        int n7 = progressionNetwork3.solution.getPrimitiveCount();
                        if (n2 == 0 || n7 < n3) {
                            if (n2 == 0) {
                                l = System.currentTimeMillis();
                            }
                            System.out.println("Found solution " + (n2 + 1) + " length " + n7);
                            solutionStep = progressionNetwork3.solution;
                            l2 = System.currentTimeMillis();
                            n3 = n7;
                            if (progressionNetwork3.progressionTrace != null) {
                                System.out.println(progressionNetwork3.progressionTrace);
                            }
                        }
                        if (bl) {
                            this.collectPlanRecData(linkedList, linkedList2, progressionNetwork3);
                        }
                        ++n2;
                        if (!this.findShortest && !bl) {
                            break block0;
                        }
                    } else {
                        priorityQueue.add(progressionNetwork3);
                    }
                    if (progressionNetwork3.metric < n5) {
                        n5 = progressionNetwork3.metric;
                        if (this.output) {
                            System.out.println(this.getInfoStr(n, priorityQueue.size(), this.greediness, progressionNetwork2, l3));
                        }
                    }
                }
                ++n;
            }
            for (ProgressionPlanStep progressionPlanStep : progressionNetwork2.getFirstAbstractTasks()) {
                for (ProMethod proMethod : progressionPlanStep.methods) {
                    ProgressionNetwork progressionNetwork4 = progressionNetwork2.decompose(progressionPlanStep, proMethod);
                    progressionNetwork4.heuristic = progressionNetwork2.heuristic.update(progressionNetwork4, progressionPlanStep, proMethod);
                    progressionNetwork4.metric = progressionNetwork4.heuristic.getHeuristic();
                    if (this.aStar) {
                        progressionNetwork4.metric += progressionNetwork4.solution.getLength();
                    }
                    progressionNetwork4.goalRelaxedReachable = progressionNetwork4.heuristic.goalRelaxedReachable();
                    if (progressionNetwork4.goalRelaxedReachable) {
                        priorityQueue.add(progressionNetwork4);
                        if (progressionNetwork4.metric < n5) {
                            n5 = progressionNetwork4.metric;
                            if (this.output) {
                                System.out.println(this.getInfoStr(n, priorityQueue.size(), this.greediness, progressionNetwork2, l3));
                            }
                        }
                    }
                    ++n;
                }
            }
            if (System.currentTimeMillis() - l4 <= 1000L) continue;
            if (l6 > 0L && System.currentTimeMillis() - l3 > l7) {
                l7 = (long)(++n6) * l6;
                System.out.println("Seems to be a bad run, let's try again! -> restart");
                priorityQueue.clear();
                priorityQueue.add(progressionNetwork);
                continue;
            }
            if (this.wallTime > 0L && System.currentTimeMillis() - l3 > this.wallTime) {
                System.out.println("Reached time limit, search will stop.");
                this.exitDueToTimeLimit = true;
                break;
            }
            l4 = System.currentTimeMillis();
            if (!this.output) continue;
            System.out.println(this.getInfoStr(n, priorityQueue.size(), this.greediness, progressionNetwork2, l3));
        }
        System.out.println("Number of nodes in final fringe: " + priorityQueue.size());
        timeCapsule.stop(SEARCH_TIME);
        if (this.findShortest) {
            informationCapsule.add("30 progression:91:findShortestPlan", 1);
        } else {
            informationCapsule.add("30 progression:91:findShortestPlan", 0);
        }
        informationCapsule.add("30 progression:92:foundShortestPlanAfter", (int)(l - l5));
        informationCapsule.add("30 progression:93:foundFirstPlanAfter", (int)(l2 - l5));
        informationCapsule.add("30 progression:94:foundPlans", n2);
        if (solutionStep != null) {
            informationCapsule.set(STATUS, "solved");
        } else if (this.exitDueToTimeLimit) {
            informationCapsule.set(STATUS, "timeout");
        } else {
            informationCapsule.set(STATUS, "proven_unsolvable");
        }
        if (this.aStar) {
            informationCapsule.set(A_STAR, 1);
        } else {
            informationCapsule.set(A_STAR, 0);
        }
        informationCapsule.set(HEURISTIC, progressionNetwork.heuristic.getClass().toString());
        informationCapsule.set(NUM_SEARCH_NODES, n);
        informationCapsule.set(UNIT_PROPAGATION, n4);
        this.setSolInfo(solutionStep, informationCapsule);
        if (this.output) {
            System.out.println("Generated search nodes (total): " + n);
        }
        if (this.output) {
            System.out.println("Search time: " + (System.currentTimeMillis() - l3) + " ms");
        }
        return solutionStep;
    }

    public void collectPlanRecData(LinkedList<Long> linkedList, LinkedList<String> linkedList2, ProgressionNetwork progressionNetwork) {
        linkedList.add(System.currentTimeMillis());
        for (Object object : progressionNetwork.solution.getSolution()) {
            int n;
            GroundedDecompositionMethod groundedDecompositionMethod;
            if (object instanceof Integer || !(groundedDecompositionMethod = (GroundedDecompositionMethod)object).groundAbstractTask().task().name().startsWith("tlt") || groundedDecompositionMethod.subPlanGroundedTasksWithoutInitAndGoal().size() <= 0 || (n = 0) >= groundedDecompositionMethod.subPlanGroundedTasksWithoutInitAndGoal().size()) continue;
            GroundTask groundTask = (GroundTask)groundedDecompositionMethod.subPlanGroundedTasksWithoutInitAndGoal().apply(n);
            linkedList2.add(groundTask.longInfo());
            break;
        }
    }

    @Override
    public String SearchName() {
        return "Priority Queue";
    }

    private void setSolInfo(SolutionStep solutionStep, InformationCapsule informationCapsule) {
        String string2 = "";
        String string3 = "";
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (solutionStep != null) {
            for (Object object : solutionStep.getSolution()) {
                Object object2;
                if (object instanceof Integer) {
                    if (ProgressionNetwork.ShopPrecActions.contains(object)) {
                        ++n3;
                        continue;
                    }
                    ++n;
                    if (string2.length() > 0) {
                        string2 = string2 + "&";
                    }
                    object2 = ProgressionNetwork.indexToTask[(Integer)object].longInfo();
                    string2 = string2 + (String)object2;
                    if (!((String)object2).startsWith("p_") || ((String)object2).charAt(2) != '0' && ((String)object2).charAt(2) != '1' && ((String)object2).charAt(2) != '2' && ((String)object2).charAt(2) != '3' && ((String)object2).charAt(2) != '4' && ((String)object2).charAt(2) != '5' && ((String)object2).charAt(2) != '6' && ((String)object2).charAt(2) != '7' && ((String)object2).charAt(2) != '8' && ((String)object2).charAt(2) != '9') continue;
                    ++n2;
                    continue;
                }
                object2 = (SimpleDecompositionMethod)object;
                if (((SimpleDecompositionMethod)object2).abstractTask().name().startsWith("tlt") && ((SimpleDecompositionMethod)object2).subPlan().planStepsWithoutInitGoal().size() > 0) {
                    for (int i = 0; i < ((SimpleDecompositionMethod)object2).subPlan().planStepsWithoutInitGoal().size(); ++i) {
                        Task task = ((PlanStep)((SimpleDecompositionMethod)object2).subPlan().planStepsWithoutInitGoal().apply(i)).schema();
                        if (string3.length() > 0) {
                            string3 = string3 + "&";
                        }
                        string3 = string3 + task.longInfo();
                    }
                }
                ++n4;
            }
        }
        informationCapsule.set(NUM_PRIM_TASKS, n);
        informationCapsule.set(NUM_SHOP_TASKS, n3);
        informationCapsule.set(NUM_DECOMPOSITIONS, n4);
        if (string3.length() > 0) {
            informationCapsule.set(INFERRED_TLT, string3);
            informationCapsule.set(ENFORCED_PREFIX_LENGTH, n2);
        }
    }

    public static enum abstractTaskSelection {
        branchOverAll,
        random,
        methodCount,
        decompDepth;


        public static abstractTaskSelection parse(String string2) {
            if (string2.equals("branchOverAll")) {
                return branchOverAll;
            }
            if (string2.equals("random")) {
                return random;
            }
            if (string2.equals("methodCount")) {
                return methodCount;
            }
            if (string2.equals("decompositionDepth")) {
                return decompDepth;
            }
            throw new IllegalArgumentException("Unknown selection strategy " + string2);
        }
    }
}

