/*
 * Decompiled with CFR 0.152.
 */
package de.uniulm.ki.panda3.symbolic.compiler.prefix;

import de.uniulm.ki.panda3.symbolic.compiler.SHOPMethodCompiler;
import de.uniulm.ki.panda3.symbolic.compiler.ToPlainFormulaRepresentation;
import de.uniulm.ki.panda3.symbolic.compiler.prefix.PrefixTransformer;
import de.uniulm.ki.panda3.symbolic.compiler.prefix.addPrefixException;
import de.uniulm.ki.panda3.symbolic.domain.Domain;
import de.uniulm.ki.panda3.symbolic.ioInterface.FileHandler;
import de.uniulm.ki.panda3.symbolic.plan.Plan;
import scala.Tuple2;

public class PANDAaddPrefix {
    private static final boolean debugMode = false;
    private static String domain_targetPath = null;
    private static String problem_targetPath = null;
    private static String[][] prefix = null;
    private static String[][] process = null;
    private static boolean verify = false;
    public static final String XML = "xml";
    public static final String RON = "ron";
    public static final String HDDL = "hddl";
    private static String outFormat = "hddl";

    public static void main(String[] stringArray) {
        System.out.println("[START]\tRepair-Transformation");
        try {
            if (stringArray.length == 0) {
                for (String string2 : PANDAaddPrefix.getExampleCall()) {
                    System.out.print(string2 + " ");
                }
                return;
            }
            Tuple2<Domain, Plan> tuple2 = PANDAaddPrefix.parseCallArguments(stringArray);
            if (prefix.length > 0) {
                PrefixTransformer prefixTransformer = process == null && verify ? PrefixTransformer.getVerifyTransformer(prefix) : (process == null && !verify ? PrefixTransformer.getRecognitionTransformer(prefix) : PrefixTransformer.getRepairTransformer(prefix, process));
                tuple2 = prefixTransformer.transform(tuple2._1(), tuple2._2(), null);
            }
            tuple2 = ToPlainFormulaRepresentation.transform(tuple2);
            tuple2 = SHOPMethodCompiler.transform(tuple2);
            if (outFormat.equals(XML)) {
                FileHandler.writeXMLToFiles(tuple2, domain_targetPath, problem_targetPath);
            } else if (outFormat.equals(RON)) {
                FileHandler.writeRonToFiles(tuple2, domain_targetPath, problem_targetPath);
            } else if (outFormat.equals(HDDL)) {
                FileHandler.writeHDDLToFiles(tuple2, domain_targetPath, problem_targetPath);
            }
        }
        catch (addPrefixException addPrefixException2) {
            System.out.println("[ABORT]\tRepairing plan failed due to PlanRepairException: " + addPrefixException2.getMessage());
            addPrefixException2.printStackTrace();
            return;
        }
        catch (Exception exception) {
            System.out.println("[ABORT]\tRepairing plan failed due to Exception: " + exception.getMessage());
            exception.printStackTrace();
            return;
        }
        System.out.println("[END]\tRepair-Transformation");
    }

    private static String[] getExampleCall() {
        String string2 = "/home/dhoeller/Dokumente/repositories/private/evaluation-domains/monroe/problems/exp-ecai/test/";
        return new String[]{"-domain", string2 + "domain.lisp", string2 + "d-0001-clear-road-wreck-0.lisp", "-problem", string2 + "p-0001-clear-road-wreck.lisp", string2 + "p-0001-clear-road-wreck-0.lisp", "-prefix", "(navegate-vehicle wcrew1 wtruck1 brighton-dump twelve-corners)"};
    }

    private static Tuple2<Domain, Plan> parseCallArguments(String[] stringArray) throws Exception {
        String string2 = "";
        String string3 = "";
        block16: for (int i = 0; i < stringArray.length; ++i) {
            switch (stringArray[i]) {
                case "-domain": {
                    string2 = stringArray[++i];
                    domain_targetPath = stringArray[++i];
                    continue block16;
                }
                case "-problem": {
                    string3 = stringArray[++i];
                    problem_targetPath = stringArray[++i];
                    continue block16;
                }
                case "-process": {
                    String[] stringArray2 = stringArray[++i].split(" ");
                    process = new String[stringArray2.length][];
                    for (int j = 0; j < stringArray2.length; ++j) {
                        String[] stringArray3 = stringArray[++i].equals("") ? new String[]{} : stringArray[i].split(" ");
                        PANDAaddPrefix.process[j] = new String[stringArray3.length + 1];
                        PANDAaddPrefix.process[j][0] = stringArray2[j];
                        for (int k = 0; k < stringArray3.length; ++k) {
                            PANDAaddPrefix.process[j][k + 1] = stringArray3[k];
                        }
                    }
                    continue block16;
                }
                case "-prefix": {
                    PANDAaddPrefix.readPrefix(stringArray[++i]);
                    continue block16;
                }
                case "-verify": {
                    verify = true;
                    PANDAaddPrefix.readPrefix(stringArray[++i]);
                    continue block16;
                }
                case "-outFormat": {
                    String string4 = stringArray[++i];
                    if (!string4.equals(RON)) continue block16;
                    outFormat = RON;
                    continue block16;
                }
                default: {
                    throw new addPrefixException("Invalid command '" + stringArray[i] + "'.");
                }
            }
        }
        return FileHandler.loadHDDLFromFile(string2, string3);
    }

    private static void readPrefix(String string2) {
        String[] stringArray = new String[]{};
        if (string2.length() > 0) {
            stringArray = string2.substring(1, string2.length() - 1).split("(\\)\\(|\\) \\(|\\)\\,\\(|\\)\\, \\()");
        }
        prefix = new String[stringArray.length][];
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split(" ");
            PANDAaddPrefix.prefix[i] = stringArray2;
        }
    }
}

