/*
 * Decompiled with CFR 0.152.
 */
package de.uniulm.ki.panda3.translation;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class formatConverterRonToOurs {
    static String initTaskRegEx = "\\(\\:tasks[\\s]+(\\([a-zA-Z0-9]+[\\s]*\\([^\\)]+\\)\\))\\)";
    static Pattern pInitTN = Pattern.compile(initTaskRegEx);
    static int newMethodID = 1;
    static String acNameRegEx = "\\(\\:action ([a-zA-Z0-9_-]*)";
    static String parameterRegEx = "\\:parameters \\(([^)]*)\\)";
    static String meNameRegEx = "\\:task \\(([^)]*)\\)";
    static Pattern pActionName = Pattern.compile(acNameRegEx);
    static Pattern pTaskName = Pattern.compile(meNameRegEx);
    static Pattern pParameter = Pattern.compile(parameterRegEx);
    static String delTaskLineRegEx = "[\\s]*:task \\([^)]*\\)";
    static String taskDefRegEx = "\\(([a-zA-Z0-9_-]+)( [^)]+)?";
    static Pattern pTask = Pattern.compile(taskDefRegEx);

    public static void main(String[] stringArray) throws Exception {
        String string2 = "/home/dh/Schreibtisch/test-ron/pfile_005.pddl";
        String string3 = "/home/dh/Schreibtisch/test-ron/pfile_005.pddl-2";
        String string4 = formatConverterRonToOurs.readFile(string2);
        if (string4.contains(":domain")) {
            formatConverterRonToOurs.processProblem(string3, string4);
        } else {
            formatConverterRonToOurs.processDomain(string3, string4);
        }
    }

    public static void processProblem(String string2, String string3) throws Exception {
        FileWriter fileWriter = new FileWriter(string2);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        bufferedWriter.write("(");
        List<String> list = formatConverterRonToOurs.parsePlan(string3);
        String string4 = "";
        String string5 = "";
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string6 : list) {
            if (string6.trim().startsWith("define")) {
                bufferedWriter.write(string6 + "\n");
                continue;
            }
            if (string6.trim().startsWith("(:domain")) {
                bufferedWriter.write(string6 + "\n");
                continue;
            }
            if (string6.trim().startsWith("(:objects")) {
                bufferedWriter.write(string6 + "\n");
                continue;
            }
            if (string6.trim().startsWith("(:init")) {
                string4 = string6;
                continue;
            }
            if (string6.trim().startsWith("(:tasks")) {
                arrayList.add(string6);
                continue;
            }
            if (string6.trim().startsWith("(:goal")) {
                string5 = string6;
                continue;
            }
            System.out.println("Error, definition type not found: " + string6);
        }
        bufferedWriter.write(" (:htn\n");
        bufferedWriter.write("  :tasks (and\n");
        for (String string6 : arrayList) {
            bufferedWriter.write(formatConverterRonToOurs.transformInitialTN(string6) + "\n");
        }
        bufferedWriter.write("  )\n");
        bufferedWriter.write("  :ordering ( )\n");
        bufferedWriter.write("  :constraints ( )\n");
        bufferedWriter.write(" )\n");
        bufferedWriter.write(formatConverterRonToOurs.transformGoalToInit(string4, string5) + "\n");
        bufferedWriter.write(string5 + "\n");
        bufferedWriter.write(")");
        bufferedWriter.close();
        fileWriter.close();
    }

    private static String transformGoalToInit(String string2, String string3) {
        String string4 = string2.trim();
        String string5 = string4.substring(0, string4.length() - 1);
        String string6 = string3.trim();
        if (!string6.startsWith("(:goal (and") || !string6.endsWith("))")) {
            System.out.println("ERROR: Could not transform goal");
        }
        string6 = string6.substring("(:goal (and".length() + 1, string6.length() - 2).trim();
        string6 = string6.replaceAll("\\(", "(goal_");
        string5 = string5 + "\n" + string6 + ")";
        return string5;
    }

    private static String transformInitialTN(String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        Matcher matcher = pInitTN.matcher(string2);
        int n = 0;
        while (matcher.find(n)) {
            stringBuilder.append("    ");
            stringBuilder.append(matcher.group(1));
            n = matcher.end();
        }
        return stringBuilder.toString();
    }

    public static void processDomain(String string2, String string3) throws Exception {
        FileWriter fileWriter = new FileWriter(string2);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        bufferedWriter.write("(");
        List<String> list = formatConverterRonToOurs.parsePlan(string3);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (String object : list) {
            if (!object.trim().startsWith("(:action")) continue;
            arrayList3.add(object);
        }
        HashMap hashMap = new HashMap();
        for (String string4 : arrayList3) {
            arrayList2.add(formatConverterRonToOurs.addNewMethods(string4, hashMap));
        }
        for (String string5 : list) {
            if (string5.trim().startsWith("define")) {
                bufferedWriter.write(string5 + "\n");
                continue;
            }
            if (string5.trim().startsWith("(:requirements")) {
                bufferedWriter.write(string5 + "\n");
                continue;
            }
            if (string5.trim().startsWith("(:types")) {
                bufferedWriter.write(string5 + "\n");
                continue;
            }
            if (string5.trim().startsWith("(:predicates")) {
                bufferedWriter.write(string5 + "\n");
                continue;
            }
            if (string5.trim().startsWith("(:tasks")) {
                bufferedWriter.write(formatConverterRonToOurs.transformTasks(string5, hashMap) + "\n");
                continue;
            }
            if (string5.trim().startsWith("(:method")) {
                arrayList.add(string5);
                continue;
            }
            if (string5.trim().startsWith("(:action")) continue;
            System.out.println("Error, definition type not found: " + string5);
        }
        for (String string6 : arrayList) {
            bufferedWriter.write(formatConverterRonToOurs.transformMethods(string6, hashMap) + "\n");
        }
        for (String string7 : arrayList2) {
            bufferedWriter.write(string7);
        }
        for (String string8 : arrayList3) {
            bufferedWriter.write(formatConverterRonToOurs.transformActions(string8) + "\n");
        }
        bufferedWriter.write(")");
        bufferedWriter.close();
        fileWriter.close();
    }

    private static String addNewMethods(String string2, Map<String, String> map2) {
        Matcher matcher = pActionName.matcher(string2);
        if (!matcher.find()) {
            System.out.println("Error: could not find action name");
            return null;
        }
        String string3 = matcher.group(1);
        Matcher matcher2 = pTaskName.matcher(string2);
        if (!matcher2.find()) {
            System.out.println("Error: could not find task name");
            return null;
        }
        String string4 = matcher2.group(1);
        String string5 = string4.split(" ")[0];
        String string6 = string5 + "_abstract";
        String string7 = string4.substring(string5.length());
        Matcher matcher3 = pParameter.matcher(string2);
        if (!matcher3.find()) {
            System.out.println("Error: could not find parameters!");
            return null;
        }
        String string8 = matcher3.group().substring(":parameters ".length());
        map2.put(string5, string6);
        String string9 = string8.substring(1, string8.length() - 1);
        String[] stringArray = string9.split(" ");
        String string10 = "";
        for (int i = 0; i < stringArray.length; i += 3) {
            string10 = string10 + stringArray[i] + " ";
        }
        string10 = string10.trim();
        return "\n (:method newMethod" + newMethodID++ + "\n  :parameters " + string8 + "\n  :task (" + string6 + " " + string7 + ")\n  :ordered-subtasks (" + string3 + " " + string10 + "))\n";
    }

    private static String transformActions(String string2) {
        return string2.replaceAll(delTaskLineRegEx, "");
    }

    private static String transformMethods(String string2, Map<String, String> map2) {
        Object object;
        String string32;
        Object object2;
        int n;
        int n2 = string2.indexOf(":parameters");
        int n3 = string2.indexOf(":task");
        if (n2 != -1) {
            if (n3 < n2) {
                int n4 = string2.indexOf("\n", n2);
                n = string2.indexOf("\n", n3);
                String string4 = string2.substring(n2, n4);
                object2 = string2.substring(n3, n);
                string32 = string2.substring(0, n3);
                string32 = string32 + string4;
                string32 = string32 + string2.substring(n, n2);
                string32 = string32 + (String)object2;
                string32 = string32 + string2.substring(n4);
                assert (string32.length() == string2.length());
                string2 = string32;
            }
        } else {
            string2 = string2.substring(0, n3) + "    :parameters ()\n" + string2.substring(n3);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string2.substring(n3, string2.indexOf("\n", n3)));
        n = string2.indexOf(":tasks");
        int n5 = string2.lastIndexOf(")");
        if (n != -1) {
            object2 = string2.substring(n, n5);
            string32 = "\\(([^)]*)\\)";
            object = Pattern.compile(string32);
            String string5 = ((String)object2).substring(((String)object2).indexOf("(") + 1, ((String)object2).lastIndexOf(")"));
            Matcher matcher = ((Pattern)object).matcher(string5);
            while (matcher.find()) {
                arrayList.add(matcher.group());
            }
        }
        for (String string32 : map2.keySet()) {
            object = map2.get(string32);
            string2 = string2.replaceAll(string32 + " ", (String)object + " ");
        }
        return string2.replaceAll("\\:tasks \\(\\(", ":ordered-tasks (and (");
    }

    private static String transformTasks(String string2, Map<String, String> map2) {
        StringBuilder stringBuilder = new StringBuilder();
        Matcher matcher = pTask.matcher(string2);
        int n = 0;
        while (matcher.find(n)) {
            String string3 = matcher.group(1);
            if (map2.containsKey(string3)) {
                string3 = map2.get(string3);
            }
            stringBuilder.append("  (:task ");
            stringBuilder.append(string3);
            stringBuilder.append(" :parameters (");
            String string4 = matcher.group(2);
            if (string4 != null) {
                stringBuilder.append(string4.trim());
            }
            stringBuilder.append("))\n");
            n = matcher.end();
        }
        return stringBuilder.toString();
    }

    private static String readFile(String string2) throws Exception {
        FileReader fileReader = new FileReader(string2);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        StringBuilder stringBuilder = new StringBuilder();
        while (bufferedReader.ready()) {
            stringBuilder.append(bufferedReader.readLine() + "\n");
        }
        bufferedReader.close();
        fileReader.close();
        return stringBuilder.toString();
    }

    private static List<String> parsePlan(String string2) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        string2 = string2.trim();
        string2 = string2.substring(1, string2.length() - 1);
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string2.length(); ++i) {
            stringBuilder.append(string2.charAt(i));
            if (string2.charAt(i) == '(') {
                ++n;
                continue;
            }
            if (string2.charAt(i) != ')' || --n != 0) continue;
            arrayList.add(stringBuilder.toString());
            stringBuilder = new StringBuilder();
        }
        return arrayList;
    }
}

