/*
 * Decompiled with CFR 0.152.
 */
package de.uniulm.ki.panda3.util.fastIntegerDataStructures;

public class UUIntStack {
    private int size;
    private intContainer currentContainer;
    private int iIter;
    private intContainer containerIter;

    public UUIntStack() {
        this(100);
    }

    public UUIntStack(int n) {
        this.size = n;
        this.currentContainer = new intContainer();
        this.currentContainer.elements = new int[n];
    }

    public void clear() {
        this.currentContainer.lastContainer = null;
        this.currentContainer.lastIndexSet = -1;
    }

    public boolean isEmpty() {
        return this.currentContainer.lastContainer == null && this.currentContainer.lastIndexSet == -1;
    }

    public void resetIterator() {
        this.containerIter = this.currentContainer;
        while (this.containerIter.lastContainer != null) {
            this.containerIter = this.containerIter.lastContainer;
        }
        this.iIter = 0;
    }

    public boolean hasNext() {
        if (this.containerIter != this.currentContainer) {
            return true;
        }
        return this.iIter <= this.containerIter.lastIndexSet;
    }

    public int next() {
        if (this.containerIter != this.currentContainer && this.iIter == this.size) {
            this.containerIter = this.containerIter.nextContainer;
            this.iIter = 0;
        }
        if (this.iIter <= this.containerIter.lastIndexSet) {
            return this.containerIter.elements[this.iIter++];
        }
        return Integer.MIN_VALUE;
    }

    public void push(int n) {
        if (this.currentContainer.lastIndexSet == this.currentContainer.elements.length - 1) {
            intContainer intContainer2 = new intContainer();
            intContainer2.elements = new int[this.size];
            intContainer2.lastContainer = this.currentContainer;
            this.currentContainer.nextContainer = intContainer2;
            this.currentContainer = intContainer2;
        }
        this.currentContainer.elements[++this.currentContainer.lastIndexSet] = n;
    }

    public int pop() {
        if (this.currentContainer.lastIndexSet >= 0) {
            return this.currentContainer.elements[this.currentContainer.lastIndexSet--];
        }
        if (this.currentContainer.lastContainer != null) {
            this.currentContainer = this.currentContainer.lastContainer;
            this.currentContainer.nextContainer = null;
            return this.currentContainer.elements[this.currentContainer.lastIndexSet--];
        }
        return Integer.MIN_VALUE;
    }

    public int top() {
        if (this.currentContainer.lastIndexSet >= 0) {
            return this.currentContainer.elements[this.currentContainer.lastIndexSet];
        }
        if (this.currentContainer.lastContainer != null) {
            this.currentContainer = this.currentContainer.lastContainer;
            return this.currentContainer.elements[this.currentContainer.lastIndexSet];
        }
        return Integer.MIN_VALUE;
    }

    class intContainer {
        int[] elements;
        int lastIndexSet = -1;
        intContainer lastContainer = null;
        intContainer nextContainer = null;

        intContainer() {
        }
    }
}

